function yf = varf(dat,p,hmax)

% Creates h-step point forecasts from VAR(p) model with intercept

% Inputs:
%	dat 			nxm data matrix
%	p			VAR order p >= 1
%	hmax			forecast horizon, hmax >= 1

% Output:
%	yf	hmax x m	point forecasts, for horizons h=1,...,hmax, for each variable
			
n = size(dat,1)-p;
m = size(dat,2);
k = m*p+1;
y = dat(1+p:n+p,:);
x = ones(n,k);
xf = ones(1,k);
for i = 1:p
    x(:,(i-1)*m+1:i*m) = dat(1+p-i:n+p-i,:);
    xf(1,(i-1)*m+1:i*m) = dat(1+n+p-i,:);
end

B = ((x'*x)\x'*y)';
J = [eye(m*(p-1)), zeros(m*(p-1),m+1);    zeros(1,m*p), 1];
P = [B; J];

yfs = zeros(hmax,m);
for h = 1:hmax
  yff = xf*((P^h)'); 
  yfs(h,:) = yff(:,1:m); 
end

yf = yfs;
