warning('off','all')
addpath([cd '\GLP']) 

p = 5;
m = 7;
k = m*p+1;
hs = [1 4 8 12];
hmax = max(hs);
irs = [1 4 8 12 16 20];
rmax = max(irs);
simpre = 20;
siminit = p;
N = 10000;
ns = [200 120 400];

load Data2016;
ir = var_ir(y,p,rmax);
ir = ir(irs+1,:,:);

dat = y ;
n = size(dat,1)-p;
y = dat(1+p:n+p,:);
x = ones(n,k);
for i = 1:p
    x(:,(i-1)*m+1:i*m) = dat(1+p-i:n+p-i,:);
end

B = ((x'*x)\x'*y)';
e = y - x*B';
sigma = (e'*e) / (n-k);
H = chol(sigma,'lower');
B1 = B(:,1:m);
B2 = B(:,m+1:2*m);
B3 = B(:,2*m+1:3*m);
B4 = B(:,3*m+1:4*m);
B5 = B(:,4*m+1:5*m);
B0 = B(:,k);

hn = size(hs,2);
nn = size(ns,2);
rn = size(irs,2);

if exist('simulation3_f.txt','file') == 2
    delete('simulation3_f.txt');
end
diary simulation3_f.txt;
diary on;
disp('---------------------')
fprintf('Number of Replications: N=%d\r\n', N);
diary off;

if exist('simulation3_ir.txt','file') == 2
    delete('simulation3_ir.txt');
end
diary simulation3_ir.txt;
diary on;
disp('---------------------')
fprintf('Number of Replications: N=%d\r\n', N);
diary off;


for ni = 1:nn
   ols_f   = zeros(hn,m,N);
   bvar_f  = zeros(hn,m,N);
   stein_f = zeros(hn,m,N);
   ols_ir  = zeros(rn,m,N); 
   bvar_ir = zeros(rn,m,N); 
   stein_ir= zeros(rn,m,N); 
   simn = ns(ni);               
   parfor rep = 1:N                   
      simy = zeros(p+simpre+simn+hmax,m);
      simy(1:p,:) = 0;
      for i = (p+1):(p+simpre+simn+hmax)
         e = H*randn(m,1);
         simy(i,:) = B1*simy(i-1,:)'+B2*simy(i-2,:)'+B3*simy(i-3,:)'+B4*simy(i-4,:)'+B5*simy(i-5,:)'+B0+e;
      end
      y = simy(p+simpre+1:p+simpre+simn,:);
      yf = simy(p+simpre+simn+1:end,:);
      yf = yf(hs,:);
                    
      % OLS
      olsyf = varf(y, p, hmax);
      ols_f(:,:,rep) = (olsyf(hs,:) - yf).^2;
      olsir = var_ir(y,p,rmax);
      ols_ir(:,:,rep) = mean((olsir(irs+1,:,:) - ir).^2,3);
                    
      % BVAR
      bvarres = bvarGLP(y,p,'hz',hmax);
      bvarf = bvarres.postmax.forecast(1:hmax,:)
      bvar_f(:,:,rep) = (bvarf(hs,:) - yf).^2;
      beta = bvarres.postmax.betahat;
      sigma = bvarres.postmax.sigmahat;
      bvarir = NaN(rmax+1,m,m);
      for i = 1:m
         bvarir(:,:,i) = bvarIrfs(beta,sigma,i,rmax+1);
      end
      bvar_ir(:,:,rep) = mean((bvarir(irs+1,:,:) - ir).^2,3);
                   
      % Stein
      [steinyf,~,~] = cvarf(y,p,hmax);
      stein_f(:,:,rep) = (steinyf(hs,:) - yf).^2;
      [steinir,~] = cvar_ir(y,p,rmax);
      stein_ir(:,:,rep) = mean((steinir(irs+1,:,:) - ir).^2,3);

   end

   ols_fm = mean(ols_f,3);
   bvar_fm = sqrt(mean(bvar_f,3) ./ ols_fm);
   stein_fm = sqrt(mean(stein_f,3) ./ ols_fm);

   diary simulation3_f.txt;
   diary on;

      disp('---------------------')
      fprintf('Root MSFE ratio: n=%.2f\r\n', simn);
      fprintf('h =\t %d\t%d\t%d\t%d\r\n',hs(1),hs(2),hs(3),hs(4));
      for j = 1:m
         fprintf('j=%d\n', j);
	 fprintf('BVAR\t %.2f\t%.2f\t%.2f\t%.2f\r\n',bvar_fm(1,j),bvar_fm(2,j),bvar_fm(3,j),bvar_fm(4,j));
	 fprintf('Stein\t %.2f\t%.2f\t%.2f\t%.2f\r\n',stein_fm(1,j),stein_fm(2,j),stein_fm(3,j),stein_fm(4,j));
      end
      disp('---------------------')

   diary off;

   ols_irm = mean(ols_ir,3);
   bvar_irm = sqrt(mean(bvar_ir,3) ./ ols_irm);
   stein_irm = sqrt(mean(stein_ir,3) ./ ols_irm);

   diary simulation3_ir.txt;
   diary on;
      disp('---------------------')
      fprintf('Root MSE ratio of Impulse Response Estimates: n=%.2f\r\n', simn);
      fprintf('h =\t %d\t%d\t%d\t%d\t%d\t%d\r\n',irs(1),irs(2),irs(3),irs(4),irs(5),irs(6));
      for j = 1:m
         fprintf('j=%d\n', j);
	 fprintf('BVAR\t %.2f\t%.2f\t%.2f\t%.2f\t%.2f\t%.2f\r\n',bvar_irm(1,j),bvar_irm(2,j),bvar_irm(3,j),bvar_irm(4,j),bvar_irm(5,j),bvar_irm(6,j));
	 fprintf('Stein\t %.2f\t%.2f\t%.2f\t%.2f\t%.2f\t%.2f\r\n',stein_irm(1,j),stein_irm(2,j),stein_irm(3,j),stein_irm(4,j),stein_irm(5),stein_irm(6,j));
      end
      disp('---------------------')
   diary off;
end


