warning('off','all')
addpath([cd '\GLP']) 

p = 5;
m = 7;
k = m*p+1;
hs = [1 4 8 12];
hmax = max(hs);
irs = [1 4 8 12 16 20];
rmax = max(irs);
simpre = 20;
siminit = p;
N = 10000;
ns = [200];
sdev = .027;

as = [0.5 0.6 0.7 0.8 0.9 0.95 0.98];
A = [0,0,0; .3,.1,.3]; % for stationariy, |c|m < 1

nA = size(A,1);
hn = size(hs,2);
nn = size(ns,2);
rn = size(irs,2);

if exist('simulation1_f.txt','file') == 2
    delete('simulation2_f.txt');
end
if exist('simulation1_ir.txt','file') == 2
    delete('simulation2_ir.txt');
end

diary simulation1_f.txt;
disp('---------------------')
disp('Average Root MSFE ratio relative to OLS');
disp('---------------------')
fprintf('Number of Replications: N = %d\r\n', N);
disp('---------------------')
diary off;

diary simulation1_ir.txt;
disp('---------------------')
disp('Average Root MSE ratio relative to OLS');
disp('---------------------')
fprintf('Number of Replications: N = %d\r\n', N);
disp('---------------------')
diary off;

for ni = 1:nn
    n = ns(ni);

    for ai = 1:nA
	b = A(ai,1);
	c = A(ai,2);
	d = A(ai,3);

	diary simulation1_f.txt;
	disp('---------------------')
        fprintf('n=%d; b=%.2f; c=%.2f; d=%.2f\n', n, b, c, d);
	disp('---------------------')
	fprintf('h =\t %d\t%d\t%d\t%d\r\n',hs(1),hs(2),hs(3),hs(4));
	disp('---------------------')
	diary off;

	diary simulation1_ir.txt;
	disp('---------------------')
        fprintf('n=%d; b=%.2f; c=%.2f; d=%.2f\n', n, b, c, d);
	disp('---------------------')
	fprintf('h =\t %d\t%d\t%d\t%d\t%d\t%d\r\n',irs(1),irs(2),irs(3),irs(4),irs(5),irs(6));
	disp('---------------------')
	diary off;

        for a = as
                    
                    ols_f  = zeros(hn,N);
                    bvar_f  = zeros(hn,N);
                    stein_f  = zeros(hn,N);
                    ols_ir = zeros(rn,N);
                    bvar_ir = zeros(rn,N);
                    stein_ir = zeros(rn,N);
                                     
                    D = ones(m,m);
                    B1 = (a+b)*eye(m)+c*D;
                    B2 = -(a*b+d)*eye(m)-(a+b)*c*D;
                    B3 = (a+b)*d*eye(m)+(a*b+d)*c*D;
                    B4 = -a*b*d*eye(m) - (a+b)*c*d*D;
                    B5 = a*b*c*d*D;
                    siminit = p;

                    % Impulse responses from the true model
                    H_true = eye(m)*sdev;
                    J_true = [eye(m*(p-1)), zeros(m*(p-1),m+1); zeros(1,m*p), 1];
                    B_true = [B1 B2 B3 B4 B5 zeros(m,1)];
                    P_true = [B_true; J_true];
                    ir_true = zeros(hmax+1,m,m);
                    Ph_true = eye(k);
                    ir_true(1,:,:) = H_true;
                    for r = 1:rmax
                        Ph_true = P_true*Ph_true;
                        ir_true(r+1,:,:) = Ph_true(1:m,1:m)*H_true;
                    end
                    ir_true = ir_true(irs+1,:,:);                      

                    parfor rep = 1:N
                        
                        simy = zeros(siminit+simpre+n+hmax,m);
                        simy(1:siminit,:) = 0;
                        for i = (siminit+1):(siminit+simpre+n+hmax)
			    e = randn(m,1)*sdev;
                            simy(i,:) = B1*simy(i-1,:)'+B2*simy(i-2,:)'+B3*simy(i-3,:)'+B4*simy(i-4,:)'+B5*simy(i-5,:)'+e;
                        end
                        y = simy(siminit+simpre+1:siminit+simpre+n,:);
                        yf = simy(siminit+simpre+n+1:end,:);
                        yf = yf(hs,:);                       
                    
                        % OLS
                        olsyf = varf(y, p, hmax);
                        ols_f(:,rep) = mean((olsyf(hs,:) - yf).^2,2);
                        olsir = var_ir(y,p,rmax);
			mols = mean((olsir(irs+1,:,:) - ir_true).^2,3);
                        ols_ir(:,rep) = mean(mols,2);
                        
                        % BVAR
                        bvarres = bvarGLP(y,p,'hz',hmax);
                        bvarf = bvarres.postmax.forecast(1:hmax,:);
                        bvar_f(:,rep) = mean((bvarf(hs,:) - yf).^2,2);
                        beta = bvarres.postmax.betahat;
                        sigma = bvarres.postmax.sigmahat;
                        bvarir = zeros(rmax+1,m,m);
                        for i = 1:m
                            bvarir(:,:,i) = bvarIrfs(beta,sigma,i,rmax+1);
                        end
			mbvar = mean((bvarir(irs+1,:,:) - ir_true).^2,3);
                        bvar_ir(:,rep) = mean(mbvar,2);
                        
                        % Stein
                        [steinyf,~,~] = cvarf(y,p,hmax);
                        stein_f(:,rep) = mean((steinyf(hs,:) - yf).^2,2);
                        [steinir,~] = cvar_ir(y,p,rmax);
			mstein = mean((steinir(irs+1,:,:) - ir_true).^2,3);
                        stein_ir(:,rep) = mean(mstein,2);
                                               
                    end
		    ols_fm = mean(ols_f,2);
		    bvar_fm = sqrt(mean(bvar_f,2) ./ ols_fm);
		    stein_fm = sqrt(mean(stein_f,2) ./ ols_fm);
		    ols_irm = mean(ols_ir,2);
		    bvar_irm = sqrt(mean(bvar_ir,2) ./ ols_irm);
		    stein_irm = sqrt(mean(stein_ir,2) ./ ols_irm);

		    diary simulation1_f.txt;
                    fprintf('a=%.2f\n', a);
		    fprintf('BVAR\t %.2f\t%.2f\t%.2f\t%.2f\r\n',bvar_fm(1),bvar_fm(2),bvar_fm(3),bvar_fm(4));
		    fprintf('Stein\t %.2f\t%.2f\t%.2f\t%.2f\r\n',stein_fm(1),stein_fm(2),stein_fm(3),stein_fm(4));
		    disp('---------------------')
    		    diary off;

		    diary simulation1_ir.txt;
                    fprintf('a=%.2f\n', a);
		    fprintf('BVAR\t %.2f\t%.2f\t%.2f\t%.2f\t%.2f\t%.2f\r\n',bvar_irm(1),bvar_irm(2),bvar_irm(3),bvar_irm(4),bvar_irm(5),bvar_irm(6));
		    fprintf('Stein\t %.2f\t%.2f\t%.2f\t%.2f\t%.2f\t%.2f\r\n',stein_irm(1),stein_irm(2),stein_irm(3),stein_irm(4),stein_irm(5),stein_irm(6));
		    disp('---------------------')
    		    diary off;


        end
    end
end