addpath([cd '\GLP']) 

load Data2016;

h = 20;
p = 5;
m = size(y,2);
hh = (0:h);

vir = var_ir(y,p,h);
[cir,weights] = cvar_ir(y,p,h);
r0 = zeros(h+1,1);

% Run the Bayesian VAR
res = bvarGLP(y,p);
beta = res.postmax.betahat;
sigma = res.postmax.sigmahat;
bvar_ir = zeros(h+1,m,m);
for j = 1:m
  bvar_ir(:,:,j) = bvarIrfs(beta,sigma,j,h+1);
end

for j = 1:m
  vj = char(ShortDescr(j));
  for i = 7
    vi = char(ShortDescr(i));
    tit1 = 'Response of ';
    tit2 = ' due to ';
    tit = [tit1,vj,tit2,vi];
    vr = vir(:,j,i)*100;
    cr = cir(:,j,i)*100;
    br = bvar_ir(:,j,i)*100;
    if i<7
      vr = vr/4;
      cr = cr/4;
      br = br/4;
    end

    figure
    plot(hh,vr,'o-b');
    hold on
    plot(hh,br,'+-m');
    plot(hh,cr,'*-k');
    plot(hh,r0,':');
    hold off
    title(tit);
    xlabel('Quarters');
    ylabel('Impulse Response Function');
    legend('OLS','BVAR','Stein','Location','northeast');
 
  end
end

i = 7;
figure
for j = 1:7
    subplot(4,2,j)
    vj = char(ShortDescr(j));
    tit = [tit1,vj,tit2,vi];
    vr = vir(:,j,i)*100;
    cr = cir(:,j,i)*100;
    br = bvar_ir(:,j,i)*100;
    if i<7
      vr = vr/4;
      cr = cr/4;
      br = br/4;
    end
    plot(hh,vr,'o-b');
    hold on
    plot(hh,br,'+-m');
    plot(hh,cr,'*-k');
    plot(hh,r0,':');
    hold off
    title(vj);
end
legend('OLS','BVAR','Stein')

w1 = sum(weights(1:5,:),1);

h1 = (1:h);
figure
    plot(h1,w1,'o-b');
    hold on
    plot(h1,weights(6,:),'+-m');
    plot(h1,weights(7,:),'d-m');
    plot(h1,weights(8,:),'.-b');
    plot(h1,weights(9,:),'x-r');
    plot(h1,weights(10,:),'s-k');
    hold off
    xlabel('Horizon');
    ylabel('Weights');
    title('Impulse Response Combination Weights');
legend('AR','VAR(1)','VAR(2)','VAR(3)','VAR(4)','VAR(5)')
