addpath([cd '\GLP']) 

load Data2016;

h = 12;
p = 5;
m = size(y,2);
time = 2016:.25:2019;

fols = varf(y,p,h); 

[fc,weights,combination_beta] = cvarf(y,p,h);
bvar = bvarGLP(y,p,'hz',h);
fb = bvar.postmax.forecast(1:h,:);
yy = y(end,:);

fols0 = zeros(h+1,m);
fols0(1,m) = yy(m)*100;
fols0(2:h+1,m) = fols(:,m)*100;
fols0(2:h+1,1:m-1) = (fols(:,1:m-1)-ones(h,1)*yy(1:m-1))*100/4;

fc0 = zeros(h+1,m);
fc0(1,m) = yy(m)*100;
fc0(2:h+1,m) = fc(:,m)*100;
fc0(2:h+1,1:m-1) = (fc(:,1:m-1)-ones(h,1)*yy(1:m-1))*100/4;

fb0 = zeros(h+1,m);
fb0(1,m) = yy(m)*100;
fb0(2:h+1,m) = fb(:,m)*100;
fb0(2:h+1,1:m-1) = (fb(:,1:m-1)-ones(h,1)*yy(1:m-1))*100/4;

for i=1:m

if i<7
  ylab = 'Cumulative Percentage Growth';
else
  ylab = 'Percentage';
end

figure
plot(time,fols0(:,i),'o-b');
hold on
plot(time,fb0(:,i),'+-m');
plot(time,fc0(:,i),'*-k');
hold off
vi = char(ShortDescr(i));
title(['Point Forecast for ',vi]);
ylabel(ylab);
legend('OLS','BVAR','Stein','Location','northwest');

end

ylims = [2016, 2019, 0, 8;  2016, 2019, 0, 7;  2016, 2019, 0, 8; 2016, 2019, 0, 14; 2016, 2019, -0.5,3; 2016, 2019, -0.5,3; 2016, 2019, .3, 1.2];

figure
for i=1:m

a(i) = subplot(4,2,i);
plot(time,fols0(:,i),'o-b');
hold on
plot(time,fb0(:,i),'+-m');
plot(time,fc0(:,i),'*-k');
hold off
title(char(ShortDescr(i)));
axis(a(i),ylims(i,:))

end
legend('OLS','BVAR','Stein');

h1 = (1:h);
for j = 1:m
w1 = sum(weights(1:5,:,j),1);
figure
    plot(h1,w1,'o-b');
    hold on
    plot(h1,weights(6,:,j),'+-m');
    plot(h1,weights(7,:,j),'d-m');
    plot(h1,weights(8,:,j),'.-b');
    plot(h1,weights(9,:,j),'x-r');
    plot(h1,weights(10,:,j),'s-k');
    hold off
    xlabel('Horizon');
    ylabel('Weights');
    vj = char(ShortDescr(j));
    title(['Forecast Combination Weights for ',vj]);
legend('AR','VAR(1)','VAR(2)','VAR(3)','VAR(4)','VAR(5)')
end