% The model includes the following data
% RGDP: 4 x logarithm of Real Gross Domestic Product, Quantity Index (2000=100) , SAAR
% PGDP: 4 x logarithm of Gross domestic product Price Index
% Cons: 4 x logarithm of Real Personal Consumption Expenditures, Quantity Index (2000=100) , SAAR
% GPDInv: 4 x logarithm of Real Gross Private Domestic Investment, Quantity Index (2000=100) , SAAR
% Emp. Hours: 4 x logarithm of HOURS OF ALL PERSONS: NONFARM BUSINESS SEC (1982=100,SA)
% Real Comp/Hour: 4 x logarithm of REAL COMPENSATION PER HOUR,EMPLOYEES:NONFARM BUSINESS(82=100,SA)
% FedFunds: INTEREST RATE: FEDERAL FUNDS (EFFECTIVE) (% PER ANNUM,NSA)
% Updated through 2016:1

clear all
close all
addpath([cd '\GLP']) 
load Data2016
% Load updated data
% The variables enter the models in annualized log-levels (i.e. we take logs and multiply by 4),
% except those already defined in terms of annualized rates, such as
% interest rates, which are taken in levels and are divided by 100.

numVar = 7;
varCols = [1 : 7]; 
hs = [1 4 8];
hmax = max(hs);
lags = 5;
NT = 221;
N = 40; 

bvarfe = zeros(N,hmax,numVar);
olsfe = zeros(N,hmax,numVar);
steinfe = zeros(N,hmax,numVar);

parfor i = 1:N
    yend = NT-N+i;
    simy = y(1:yend,varCols);
    
    % Bayesian VAR
    res = bvarGLP(simy,lags);
    yftmp = res.postmax.forecast(:,:);
    bvarfe(i,:,:) = yftmp - y(yend+1:yend+hmax, varCols);
    
    % OLS
    yftmp = varf(simy, lags, hmax);
    olsfe(i,:,:) = yftmp - y(yend+1:yend+hmax, varCols);
    
    % Stein
    [yftmp,~,~] = cvarf(simy,lags,hmax);
    steinfe(i,:,:) = yftmp - y(yend+1:yend+hmax, varCols);
    
end

bvarmsfe = zeros(hmax,numVar);
olsmsfe = zeros(hmax,numVar);
steinmsfe = zeros(hmax,numVar);

for h = 1:hmax
    bvarmsfe(h,:) = mean(bvarfe(:,h,:).^2,1)/h^2*10000;
    olsmsfe(h,:) = mean(olsfe(:,h,:).^2,1)/h^2*10000;
    steinmsfe(h,:) = mean(steinfe(:,h,:).^2,1)/h^2*10000;
end

% Display results
if exist('GLPoos.txt','file') == 2
    delete('GLPoos.txt');
end
diary 'GLPoos.txt'
diary on
clc
disp('---------------------')
disp('MSFE of Point Forcasts')
disp('---------------------')
for h = [1 4 8]
    disp(['h=',num2str(h),':'])
    fprintf('\t\tOLS\tBVAR\tStein\n')
    for j = 1:numVar
        fprintf('%s',char(ShortDescr(j)));
        fprintf('\t%.2f\t%.2f\t%.2f\r\n',olsmsfe(h,j),bvarmsfe(h,j),steinmsfe(h,j))
    end
    disp('---------------------')
end
diary off