#########################################################################
##  SHIFTS.R
##  
##  This is a R program.
##  It calculates the statistics discussed in
##  "Residual-based tests for cointegration in models
##  with regime shifts"
##  by Allan W. Gregory and Bruce E. Hansen
##  
##  Questions about the program can be addressed to
##  
##  Bruce E. Hansen
##  Department of Economics
##  Social Science Building
##  University of Wisconsin
##  Madison, WI 53706-1393
##  behansen@wisc.edu
##  http://www.ssc.wisc.edu/~bhansen/
##  
#########################################################################

# ******** testing program ******** #
xx1 <- as.matrix(read.table("mon59m.dat"))  
xx2 <- as.matrix(read.table("mon46q.dat")) 
xx3 <- as.matrix(read.table("mon47q.dat")) 
xx4 <- as.matrix(read.table("mon47m.dat")) 

# ----- Create Quarterly M1 and 3M-TB Series from Monthly Series ----- #

xx1q <- matrix(0,4*(nrow(xx1)-5)/12,1) 
xx4q <- matrix(0,nrow(xx3),1) 
jm <- 1 
jmc <- 1 
endm <- nrow(xx1)-5 

while (jm <= endm){ 
   xx1q[jmc,] <- mean(xx1[jm:(jm+2),]) 
   jmc <- jmc + 1 
   jm <- jm + 3 
}
jr <- 3 
jrc <- 1 
endr <- nrow(xx4)-5 
while (jr <= endr){
   xx4q[jrc,] <- xx4[jr,2] 
   jrc <- jrc + 1 
   jr <- jr + 3 
}

# ----- Set Sample: 1959.1 - 1990.4 ----- #

ynr <- xx3[49:176,1]               # ynr - Net National Product, Billions of 82$ #
pp <- xx2[53:180,1]/xx3[49:176,1]  # pp - Implicit Price Deflator, PI #
m1 <- xx1q[1:128,1]/pp             # m1/p - M1, Billions of $ #
sr <- xx4q[49:176,1]               # sr - 3 Month T-Bills #
ynr <- as.matrix(ynr)
pp <- as.matrix(pp)
m1 <- as.matrix(m1)
sr <- as.matrix(sr)

obs <- nrow(m1) 

n <- obs 
md <- log(m1)
ynr <- log(ynr)

# cat ("Log of Real Money Balances",y,"\n")
# cat ("Income and Interest Rates",x,"\n")

source ("main.R")
y <- md
x <- cbind(ynr,sr)
out <- main(y,x,4,4,6)

