/********************************************************
UR.PRG

written by
Bruce E. Hansen
Department of Economics
University of Wisconsin
www.ssc.wisc.edu/~bhansen

This program replicates Table 3 and Figure 1 from
"Interval Forecasts and Parameter Uncertainty"
August, 2004

*********************************************************/

#include qinterval.prc;

library pgraph;

load lhc[]=lhc.dat;
load lhuem[]=lhuem.dat;
dat=lhuem./lhc*100;
n=rows(dat);

/**************************************/

@ Compare pseudo-out-of-sample forecast intervals @

let hh= 1 3 6 9 12;
hn=rows(hh);
let ss= 60 120 180 240;
sn=rows(ss);
kmax=12;
let alpha = .1 .9;

store1=zeros(hn,sn);
store2=store1;
store3=store1;
store4=store1;
for hi (1,hn,1);
for si (1,sn,1);
 sample=ss[si];
 horizon=hh[hi];
 forecast1=zeros(n-sample-horizon+1,1);
 forecast2=zeros(n-sample-horizon+1,1);
 forecast3=zeros(n-sample-horizon+1,1);
 forecast4=zeros(n-sample-horizon+1,1);
 yf=dat[sample+horizon:n];
 for t (1,n-sample-horizon+1,1);
    yt=yf[t];
    datt=dat[t:t+sample-1];
    k=aic(datt,horizon,kmax);
    y=datt[horizon+k:sample];
    x=datt[k:sample-horizon];
    for i (2,k,1);
      x=x~datt[k-i+1:sample-horizon-i+1];
    endfor;
    ny=rows(y);
    xn=rev(y[ny-k+1:ny]);
    {q1,q2,q3,q4}=qinterval(y,x,xn,horizon,alpha);
    forecast1[t]=(yt.<=q1[2]).*(yt.>=q1[1]);
    forecast2[t]=(yt.<=q2[2]).*(yt.>=q2[1]);
    forecast3[t]=(yt.<=q3[2]).*(yt.>=q3[1]);
    forecast4[t]=(yt.<=q4[2]).*(yt.>=q4[1]);
  endfor;
  store1[hi,si]=meanc(forecast1);
  store2[hi,si]=meanc(forecast2);
  store3[hi,si]=meanc(forecast3);
  store4[hi,si]=meanc(forecast4);
endfor;
endfor;

format 12,3;
output file = "ur.out" reset;
"Rough Interval (Nominal 80%)";"";
0~ss';
hh~store1;
"";"";
"Simple Reference Interval (Nominal 80%)";"";
0~ss';
hh~store2;
"";"";
"Convolution Interval (Nominal 80%)";"";
0~ss';
hh~store3;
"";"";
"NonParametric Interval (Nominal 80%)";"";
0~ss';
hh~store4;
"";"";
output off;



/**************************************/

@ Plot forecast intervals over time against actual @

sample=180;
horizon=3;

years=seqa(1948+(sample+horizon-1)/12,1/12,n-sample+1-horizon);
forecasts=zeros(n-sample-horizon+1,3)+miss(0,0);
forecasts[.,1]=dat[sample+horizon:n];
for t (1,n-sample-horizon+1,1);
    datt=dat[t:t+sample-1];
    k=aic(datt,horizon,kmax);
    y=datt[horizon+k:sample];
    x=datt[k:sample-horizon];
    for i (2,k,1);
      x=x~datt[k-i+1:sample-horizon-i+1];
    endfor;
    ny=rows(y);
    xn=rev(y[ny-k+1:ny]);
    {q1,q2,q3,q4}=qinterval(y,x,xn,horizon,alpha);
    forecasts[t,2:3]=q2';
endfor;

graphset;
pqgwin many;
xtics(1970,2005,5,5);
ytics(3,12,1,10);
let _pltype = 3 6 4;
let _pmcolor = 0 0 0 0 0 0 0 0 15;
let _pcolor = 10 0 9 ;
_plwidth=5;
_pdate="";
ylabel("Unemployment Rate");
let _plegctl= 1 3 1995 10;
_plegstr="90% Forecast Quantile\000Actual\00010% Forecast Quantile";
title("80% Forecast Intervals");
tit = "" $+ "Sample Size = " $+ ftocv(sample,2,0) $+ ",  Forecast Horizon = " $+ ftocv(horizon,1,0);
xlabel(tit);
xy(years,forecasts[.,3 1 2]);



/****AIC****************************
Computes lag order using AIC 
*****************************************/
proc aic(dat,horizon,kmax);
local n,t,y,ab,x,i,e,k;
  n=rows(dat);
  t=n-horizon-kmax+1;
  y=dat[horizon+kmax:n];
  ab=zeros(kmax,1);
  x=ones(t,1);
  for i (1,kmax,1);
    x=x~dat[kmax-i+1:n-horizon-i+1];
    e=y-x*(y/x);
    ab[i]=ln(e'e/t)+2*(1+i)/t;
  endfor;
  k=minindc(ab);
retp(k);
endp;

