/********************************************************
FAN.PRG

written by
Bruce E. Hansen
Department of Economics
University of Wisconsin
www.ssc.wisc.edu/~bhansen

This program produces the Fan Chart (Figure 2) from
"Interval Forecasts and Parameter Uncertainty"
August, 2004

*********************************************************/

#include qinterval.prc;

library pgraph;

load lhc[]=lhc.dat;
load lhuem[]=lhuem.dat;
dat=lhuem./lhc*100;
n=rows(dat);
kmax=12;
let alpha = .1 .9;

sample=180;
horizon=19;
nalpha=9;
alpha = seqa(.1,.1,nalpha);

st=7;
nn=st+horizon;

datt=dat[n+1-sample:n];
forecast=zeros(nn,nalpha)+miss(0,0);
forecast[st,.]=ones(1,nalpha)*datt[sample];
realized=dat[n+1-st:n]|(zeros(horizon,1)+miss(0,0));
for h (1,horizon,1);
    k=aic(datt,h,kmax);
    y=datt[h+k:sample];
    x=datt[k:sample-h];
    for i (2,k,1);
      x=x~datt[k-i+1:sample-h-i+1];
    endfor;
    ny=rows(y);
    xn=rev(y[ny-k+1:ny]);
    {q1,q2,q3,q4}=qinterval(y,x,xn,h,alpha);
    forecast[st+h,.]=q2';
endfor;

y1=2004;
years=seqa(y1,1/12,nn);

graphset;
pqgwin many;
xtics(y1,y1+2,1,12);
ytics(4,7,1,10);
let _pltype = 6 1 2 3 4 5 4 3 2 1;
let _pmcolor = 0 0 0 0 0 0 0 0 15;
let _pcolor=0 1 9 10 6 1 6 10 9 1;
_plwidth=5;
_pdate="";
tit = "" $+ "Sample Size = " $+ ftocv(sample,2,0) ;
xlabel(tit);
title("Forecast Quantiles for Unemployment Rate");
ylabel("Unemployment Rate");
xy(years,realized~forecast);



/****AIC****************************
Computes lag order using AIC 
*****************************************/
proc aic(dat,horizon,kmax);
local n,t,y,ab,x,i,e,k;
  n=rows(dat);
  t=n-horizon-kmax+1;
  y=dat[horizon+kmax:n];
  ab=zeros(kmax,1);
  x=ones(t,1);
  for i (1,kmax,1);
    x=x~dat[kmax-i+1:n-horizon-i+1];
    e=y-x*(y/x);
    ab[i]=ln(e'e/t)+2*(1+i)/t;
  endfor;
  k=minindc(ab);
retp(k);
endp;

