#########################################################################
##  EXAMPLE.PRG
##  
##  This file illustrates the procedures for
##  "Testing for Structural Change in Conditional Models"
##  
##  The program fits the first equation from a bi-variate VAR(6) 
##  in M2 and the 3-month T-bill rate, and tests for parameter
##  instability in the VAR parameters.
##   
##  There are no outputs. Results are printed to the screen.
##  
##  This program is written by
##  
##  Bruce E. Hansen
##  Department of Economics
##  Social Science Building
##  University of Wisconsin
##  Madison, WI 53706-1393
##  behansen@wisc.edu
##  http://www.ssc.wisc.edu/~bhansen/
##  
##  The file calls the procedure break_t contained in the ASCII file
##  break.R, which calls procedures contained in the ASCII files
##  pv_sup.R, pv_exp.R and pv_ave.R
##  
##  The file loads the ASCII files fygm3.dat and fm2.dat.
##  
#########################################################################

source ("break.R")
fygm3 <- read.table("fygm3.dat")
fm2 <- read.table("fm2.dat")
fygm3 <- as.matrix(fygm3)
fm2 <- as.matrix(fm2)

t <- 432
y <- log(fm2)
n <- nrow(y)
yy <- as.matrix(y[(n-t+1):n]-y[(n-t):(n-1)])
x <- fygm3
n <- nrow(x)
xx <- as.matrix(x[(n-t+1):n]-x[(n-t):(n-1)])

lag <- 6
pi1 <- .15
pi2 <- .85
for (main in 1:1){
cat ("Autoregressive Lag Order= ", lag,"\n")
  y <- as.matrix(yy[(1+lag):t])
  x <- matrix(1,(t-lag),1)  
  qvar <- rbind("M2","Constant")

  for (l in 1:lag){
    x <- cbind(x,as.matrix(yy[(1+lag-l):(t-l)]),as.matrix(xx[(1+lag-l):(t-l)]))
    qy <- paste("M2(-",l,")",sep="")
    qx <- paste("i3(-",l,")",sep="") 
    qvar <- rbind(qvar,qy,qx)
  }
  out <- break_t(y,x,qvar,pi1,pi2)
  cat ("\n")
  cat ("\n")
}

