% EXAMPLE.M

% This file illustrates the procedures for
% "Testing for Structural Change in Conditional Models"

% The program fits the first equation from a bi-variate VAR(6) 
% in M2 and the 3-month T-bill rate, and tests for parameter
% instability in the VAR parameters.

% The output is written to the file "example.txt".

% This program is written by

% Bruce E. Hansen
% Department of Economics
% Social Science Building
% University of Wisconsin
% Madison, WI 53706-1393
% bhansen@ssc.wisc.edu
% http://www.ssc.wisc.edu/~bhansen/

% The file calls the procedure break_t contained in the ASCII file
% break_t.m, which calls procedures contained in the ASCII files
% pv_sup.m, pv_exp.m and pv_ave.m

% The file loads the ASCII files fygm3.txt and fm2.txt.
global out;
load fygm3.txt;
load fm2.txt;

t=432;
y=log(fm2);
n=length(y(:,1));
yy=y(n-t+1:n)-y(n-t:n-1);
x=fygm3;
n=length(x(:,1));
xx=x(n-t+1:n)-x(n-t:n-1);

out=fopen('example.txt','wt');
lag=6;
fprintf(out,'Autoregressive Lag Order:  %u\n',lag);

pi1=.15;
pi2=.85;
y=yy(1+lag:t);
x=ones(t-lag,1);
qvar=['______M2';'Constant'];
l=1;
while l<=lag;
    x=[x,yy(1+lag-l:t-l),xx(1+lag-l:t-l)];
    qy=strcat('__M2(-',num2str(l),')');
    qx=strcat('__i3(-',num2str(l),')');
    qvar=[qvar;qy;qx];
    l=l+1;
end;
break_t(y,x,qvar,pi1,pi2);
fclose(out);