/* EXAMPLE.PRG

This file illustrates the procedures for
"Testing for Structural Change in Conditional Models"

The program fits the first equation from a bi-variate VAR(6) 
in M2 and the 3-month T-bill rate, and tests for parameter
instability in the VAR parameters.

The output is written to the file "example.out".

This program is written by

Bruce E. Hansen
Department of Economics
Social Science Building
University of Wisconsin
Madison, WI 53706-1393
bhansen@ssc.wisc.edu
http://www.ssc.wisc.edu/~bhansen/

The file calls the procedure break_t contained in the ASCII file
break.prc, which calls procedures contained in the ASCII files
pv_sup.prc, pv_exp.prc and pv_ave.prc

The file loads the ASCII files fygm3.db and fm2.db.

*/

#include break.prc;
load fygm3[]=fygm3.db;
load fm2[]=fm2.db;

t=432;
y=ln(fm2);
n=rows(y);
yy=y[n-t+1:n]-y[n-t:n-1];
x=fygm3;
n=rows(x);
xx=x[n-t+1:n]-x[n-t:n-1];

format 9,4;
output file = example.out reset;

lag = 6;
"Autoregressive Lag Order= " lag;

pi1=.15;
pi2=.85;
  y = yy[1+lag:t];
  x = ones(t-lag,1);
  let qvar = "M2" "Constant";
  l=1; do while l<=lag;
    x = x~yy[1+lag-l:t-l]~xx[1+lag-l:t-l];
    ll = ftos(l,"%*.*lf",1,0);
    qy = "M2(-" $+ ll $+ ")";
    qx = "i3(-" $+ ll $+ ")";
    qvar=qvar|qy|qx;
  l=l+1;endo;
  break_t(y,x,qvar,pi1,pi2);
  "";"";
output off;

