#########################################################################
## ST_CHANG.R 
## procs for structural change analysis
#########################################################################

x_ar <- function(y,k){
yy <- matrix(1,k,1)%*%t(y)
for (i in 1:k) yy[i,]<-t(rbind(t((0/0)%*%matrix(1,1,i)),as.matrix(y[1:(nrow(y)-i)])))
yy <- t(yy)
yy <- as.matrix(yy[(k+1):nrow(y),])
yy
}

splitest <- function(y,x,s,trim){
t <- nrow(y)
t1 <- round(t*trim)
t2 <- round(t*(1-trim))
e <- y-x%*%qr.solve(x,y)
tr <- seq(1,t,1)
ss <- matrix(1,t,1)+as.vector(t(e)%*%e)
if (s==0) xs <- x else xs <- as.matrix(x[,s]) 
for (i in t1:t2){
  d <- as.matrix((tr>i))
  z <- xs*(d%*%matrix(1,1,ncol(xs)))
  z <- z-x%*%qr.solve(x,z)
  u <- e-z%*%qr.solve(z,e)
  ss[i] <- t(u)%*%u
}
kest <- which.min(ss)
list(kest=kest,ss=ss)
}

bai_qnt <- function(xsi,phi,alpha){
xp <- xsi/phi
a <- xp*(1+xp)/2
b <- 1/2+xp
c <- phi*(phi+2*xsi)/(phi+xsi)/xsi
d <- ((phi+2*xsi)^2)/xsi/(phi+xsi)
x1 <- seq(-50,-50+.01*4999,.01)
x2 <- seq(.01,50,.01)
g1 <- -sqrt(-x1/(2*pi))*exp(x1/8)-c*exp(-x1*a)*pnorm(-b*sqrt(-x1))+
      (d-2-x1/2)*pnorm(-sqrt(-x1)/2)
a <- (phi+xsi)/2
b <- (2*phi+xsi)/2/sqrt(phi)
c <- xsi*(2*phi+xsi)/phi/(phi+xsi)
d <- ((2*phi+xsi)^2)/phi/(phi+xsi)
g2 <- 1+xsi*sqrt(x2/(2*pi*phi))*exp(-x2*xsi*xsi/8/phi)+
      c*exp(x2*a)*pnorm(-sqrt(x2)*b)+
      (-d+2-x2*xsi*xsi/2/phi)*pnorm(-sqrt(x2/phi)*xsi/2)
x <- rbind(as.matrix(x1),as.matrix(x2))
g <- rbind(as.matrix(g1),as.matrix(g2))
c1 <- x[which.max(g>(alpha/2))]
c2 <- x[which.max(g>(1-alpha/2))]
list(c1=c1,c2=c2)
}

supw <- function(y,x,trimsup,trimexp){
t <- nrow(y)
kk <- ncol(x)
f <- matrix(0,t,kk+1)  
trim <- min(rbind(trimsup,trimexp))
tr <- as.matrix(seq(1,t,1))
t1 <- round(t*trim)
t2 <- round(t*(1-trim))
e <- y-x%*%qr.solve(x,y)
for (i in t1:t2){
  d <- (tr>i)
  for (j in 1:kk){
    z <- x[,j]*d
    z <- z-x%*%qr.solve(x,z)
    ze <- t(z)%*%e
    beta <- solve(t(z)%*%z)%*%ze
    zee <- z*(e-z%*%beta)
    v <- t(zee)%*%zee 
    f[i,j] <- t(ze/v)%*%ze
  }
  z <- x*(d%*%matrix(1,1,ncol(x)))
  z <- z-x%*%qr.solve(x,z)
  ze <- t(z)%*%e
  beta <- solve(t(z)%*%z,tol=1e-100,LAPACK=FALSE)%*%ze
  zee <- z*((e-z%*%beta)%*%matrix(1,1,ncol(z)))
  v <- t(zee)%*%zee 
  f[i,kk+1] <- t(qr.solve(v,ze))%*%ze
}
t1 <- round(t*trimsup)
t2 <- round(t*(1-trimsup))
fsup <- matrix(0,t,kk+1)
fsup[t1:t2,] <- f[t1:t2,]
kest <- as.matrix(max.col(t(fsup)))
supf <- as.matrix(apply(fsup,2,max))
expf <- as.matrix(log(colMeans(exp(f[round(t*trimexp):round(t*(1-trimexp)),]/2))))
list(fsup=fsup,supf=supf,expf=expf,kest=kest)
}

qa_crit <- function(k,trim){
crits <- matrix(c(
8.45,	 8.85,  9.31,  9.84,
11.26, 11.79, 12.27, 12.93,
13.69, 14.15, 14.62, 15.15,
15.84, 16.45, 16.98, 17.56,
17.88, 18.35, 18.93, 19.61,
19.64, 20.26, 20.82, 21.56,
21.07, 21.84, 22.51, 23.22,
21.47, 22.13, 22.87, 23.6,
24.91, 25.47, 26.16, 26.94,
26.42, 27.03, 27.87, 28.63,
27.93, 28.55, 29.21, 30.15,
29.61, 30.16, 30.88, 31.76,
31.1,  31.8,  32.62, 33.42,
32.65, 33.45, 34.22, 35,
34.41, 35.06, 35.76, 36.74,
35.95, 36.66, 37.48, 38.51,
37.49, 38.12, 39.05, 40.05,
38.77, 39.55, 40.38, 41.36,
40.43, 41.25, 42.01, 43.05,
41.9,	 43,	  43.76, 44.52),
20,4,byrow=TRUE)
crit <- 0/0
if (trim==.2) crit <- crits[k,1]
if (trim==.15) crit <- crits[k,2]
if (trim==.10) crit <- crits[k,3]
if (trim==.05) crit <- crits[k,4]
crit
}

ap_crit <- function(k,trim){
crits <- matrix(c(
2.06,	2.08,	2.08,	2.08,
3.22,	3.25,	3.27,	3.3,
4.22,	4.28,	4.3,	4.3,
5.23,	5.24,	5.3,	5.34,
6.13,	6.17,	6.22,	6.25,
6.92,	9.98,	7.09,	7.12,
7.66,	7.77,	7.85,	7.95,
8.6,	8.68,	8.79,	8.86,
9.35,	9.42,	9.55,	9.63,
10.04,10.19,10.34,10.43,
10.75,10.88,11.01,11.12,
11.55,11.65,11.78,11.86,
12.28,12.49,12.55,12.84,
13.09,13.2,	13.31,13.59,
13.84,10.01,14.16,14.28,
14.63,14.8,	14.96,15.13,
15.3,	15.52,15.7,	15.87,
15.93,16.12,16.3,	16.46,
16.73,16.89,17.1,	17.21,
17.57,17.73,17.92,18),
20,4,byrow=TRUE)
crit <- 0/0
if (trim==.15) crit <- crits[k,1]
if (trim==.10) crit <- crits[k,2]
if (trim==.05) crit <- crits[k,3]
if (trim==.02) crit <- crits[k,4]
crit
}

chi_crit <- function(k){
crits <- matrix(c(3.84, 5.99, 7.81, 9.49, 11.07, 12.59, 14.07, 15.51,
    16.92, 18.31, 19.68, 21.03, 22.36, 23.68, 25, 26.3, 27.59, 28.87, 
    30.14, 31.41),20,1)
crit <- crits[k]
crit
}

