#########################################################################
##  
##  This file contains two R procedures:
##  PV_EXP and EXP_BETA
##  
##      written by
##  
##  Bruce E. Hansen
##  Department of Economics
##  Social Science Building
##  University of Wisconsin
##  Madison, WI 53706-1393
##  behansen@wisc.edu
##  http://www.ssc.wisc.edu/~bhansen/
##  
##  The format for the procedures are
##  
##  p <- pv_exp(Tn,m,l)
##  b <- exp_beta(k)
##  
##  The documentation follows.
##  
##  *************************************************************
##  
##  PV_EXP
##  
##  Procedure to compute asymptotic p-values for Andrews-Ploberger
##  Exp Test based on approximation used in my paper
##  "Approximate Asymptotic P-Values for Structural Change Tests".
##  
##  Format:
##  
##  p <- pv_exp(Tn,m,l)
##  
##  Inputs:
##  Tn   =  Value of Exp Statistic
##  m    =  Number of parameters tested for constancy
##          (degrees of freedom of conventional Chow test)
##  l    =  Either the "lambda" or the "pi_0" of Andrews-Ploberger
##          Lambda lies between [1,infinity) and pi_0 between (0,1/2].
##          pi_0 is convenient when the test is constructed using symmetric
##          trimming, and Lambda is convenient when non-symmetric trimming is
##          used.
##  
##  Output:
##  p    =  Asymptotic p-value of test statistic
##  
##  *************************************************************
##  
##  EXP_BETA
##  
##  Procedure to return coefficients for computation of p-value function
##  for the Exp test, given degrees of freedom.
##  
##  Format:
##  
##  beta <- exp_beta(k)
##  
##  Input:
##  k  = degrees of freedom (number of parameters tested for constancy)
##  
##  Output:
##  beta = 25xg matrix.
##         Each row consists of coefficients for p-value function.
##         The rows correspond to pi_0 indexed from .49 to .01 (decreasing)
##         in steps of .02.  The number of columns, g, depends on k.
##  
#########################################################################

exp_beta <- function(k){

if (k == 1) beta <- matrix(
c( -0.00205601    ,2.36859950   ,-0.23305461    ,0.04504892    ,1.09849179,
   -0.04350992    ,2.23155409   ,-0.15096467    ,0.02824740    ,1.05290825,
   -0.07621043    ,2.15120757   ,-0.10611353    ,0.02067033    ,1.02677361,
   -0.10080565    ,2.28694107   ,-0.17194493    ,0.03387317    ,1.06885660,
   -0.12674914    ,2.35549245   ,-0.20531519    ,0.04206304    ,1.09079971,
   -0.14959590    ,2.53088090   ,-0.29542135    ,0.05939184    ,1.14814083,
   -0.17220537    ,2.71412534   ,-0.37895759    ,0.07335757    ,1.21062389,
   -0.19495705    ,2.81063137   ,-0.41493314    ,0.07929199    ,1.24904833,
   -0.21671427    ,3.00270378   ,-0.49135475    ,0.09146795    ,1.32250558,
   -0.23645304    ,3.09852305   ,-0.50955670    ,0.09041431    ,1.36611837,
   -0.25801745    ,3.25266033   ,-0.56938051    ,0.09986163    ,1.42757248,
   -0.27780476    ,3.23720522   ,-0.52216505    ,0.08667827    ,1.44010452,
   -0.29824081    ,3.32580101   ,-0.54486767    ,0.08889176    ,1.48170930,
   -0.32191494    ,3.46657528   ,-0.60625356    ,0.10029263    ,1.53957935,
   -0.34160691    ,3.54525887   ,-0.62758508    ,0.10254370    ,1.57918355,
   -0.36683016    ,3.65755822   ,-0.65767829    ,0.10540837    ,1.63091391,
   -0.38942071    ,3.68066109   ,-0.64174941    ,0.10016818    ,1.65377665,
   -0.41546194    ,3.75135495   ,-0.65483135    ,0.10063927    ,1.68830619,
   -0.44639265    ,3.93282105   ,-0.72326259    ,0.11173848    ,1.76579085,
   -0.48592752    ,4.07048699   ,-0.79387494    ,0.12737490    ,1.81223838,
   -0.52165072    ,4.11796059   ,-0.79887231    ,0.12846472    ,1.83687871,
   -0.56783761    ,4.36989822   ,-0.90718758    ,0.14661825    ,1.93366874,
   -0.61273440    ,4.65524656   ,-1.00816574    ,0.16025556    ,2.05886213,
   -0.65960831    ,4.95914040   ,-1.08864366    ,0.16643497    ,2.21155252,
   -0.74262905    ,5.22577119   ,-1.15699988    ,0.17149396    ,2.33347186),
25,5,byrow=TRUE)

if (k == 2) beta <- matrix(
c( -0.06077391    ,1.98152903    ,0.00108896    ,1.94947276,
   -0.10671753    ,1.97805138    ,0.00442752    ,1.95332184,
   -0.16554774    ,1.90790820    ,0.01690173    ,1.89207378,
   -0.22361130    ,1.91786877    ,0.01257038    ,1.88380187,
   -0.25935809    ,2.01759791   ,-0.00342610    ,1.96568682,
   -0.30084745    ,2.06236954   ,-0.00864169    ,2.00298604,
   -0.33774327    ,2.10784479   ,-0.01261847    ,2.04756667,
   -0.37844045    ,2.13359190   ,-0.01512258    ,2.06894324,
   -0.41403586    ,2.18029294   ,-0.01848366    ,2.11632756,
   -0.44923494    ,2.19481085   ,-0.01710873    ,2.13615560,
   -0.48580580    ,2.21818181   ,-0.01794353    ,2.16192557,
   -0.51645535    ,2.30834848   ,-0.02706244    ,2.25512671,
   -0.54855859    ,2.32423034   ,-0.02509902    ,2.28024062,
   -0.58788583    ,2.28360713   ,-0.01381872    ,2.25377365,
   -0.62622258    ,2.35341462   ,-0.02314283    ,2.31472401,
   -0.67424320    ,2.39941816   ,-0.02910836    ,2.35072215,
   -0.72300058    ,2.49861052   ,-0.04321778    ,2.43242693,
   -0.76804658    ,2.66074495   ,-0.06635619    ,2.57852729,
   -0.81477040    ,2.76223592   ,-0.07759735    ,2.67939863,
   -0.86677581    ,2.77962271   ,-0.07729976    ,2.69578879,
   -0.91088039    ,2.90865108   ,-0.09016694    ,2.83477898,
   -0.97261665    ,3.00978939   ,-0.10094037    ,2.93416093,
   -1.06663861    ,3.04779425   ,-0.10520091    ,2.94185532,
   -1.17118353    ,3.16255411   ,-0.11924718    ,3.02993242,
   -1.33653777    ,3.32233051   ,-0.13956625    ,3.13017487),
25,4,byrow=TRUE)

if (k == 3) beta <- matrix(
c(  0.10140182    ,2.25063857   ,-0.03168921    ,3.40673105,
    0.02156696    ,2.25834873   ,-0.03034420    ,3.41978704,
   -0.14713065    ,2.12452615   ,-0.01477643    ,3.17681851,
   -0.16816557    ,2.28772955   ,-0.03438261    ,3.40972366,
   -0.35357271    ,2.02987029   ,-0.00221643    ,2.99889826,
   -0.46525484    ,1.96913272   , 0.00352381    ,2.87309699,
   -0.51648857    ,2.05061048   ,-0.00512832    ,2.98169510,
   -0.56150778    ,2.07967193   ,-0.00500535    ,3.04086173,
   -0.58459748    ,2.25831752   ,-0.02445665    ,3.30261085,
   -0.63733496    ,2.23316708   ,-0.01702445    ,3.28755349,
   -0.62213641    ,2.42962126   ,-0.03514134    ,3.62259608,
   -0.67000948    ,2.56368173   ,-0.05016622    ,3.80997000,
   -0.67303189    ,2.74346210   ,-0.06650315    ,4.11155122,
   -0.84746374    ,2.67967151   ,-0.06323507    ,3.90546381,
   -0.89837890    ,2.78463614   ,-0.07299205    ,4.05969039,
   -0.97701572    ,2.86915625   ,-0.08196876    ,4.16097953,
   -1.07305991    ,2.88259957   ,-0.08260348    ,4.14773065,
   -1.16062736    ,2.91102163   ,-0.08409545    ,4.16250418,
   -1.22965677    ,2.99863582   ,-0.09063501    ,4.29570022,
   -1.30293052    ,3.05968797   ,-0.09353066    ,4.39358371,
   -1.42636318    ,3.07035384   ,-0.09352956    ,4.36087078,
   -1.53850738    ,3.07670091   ,-0.09216854    ,4.34192277,
   -1.66180480    ,3.29287857   ,-0.11280160    ,4.64135609,
   -1.80546088    ,3.45193296   ,-0.12621529    ,4.85800733,
   -2.10073182    ,3.54158462   ,-0.13310524    ,4.86004072),
25,4,byrow=TRUE)

if (k == 4) beta <- matrix(
c( -0.03699697    ,2.00377403    ,4.02209982,
   -0.14300359    ,1.99658819    ,3.99995578,
   -0.26083639    ,1.98665033    ,3.95207686,
   -0.37595492    ,1.99057536    ,3.93104100,
   -0.50113154    ,1.97869533    ,3.86384417,
   -0.61815519    ,1.97374217    ,3.81505646,
   -0.66404042    ,2.00752248    ,3.91445029,
   -0.71744956    ,2.02914326    ,3.97647915,
   -0.79442704    ,2.04084343    ,3.99709983,
   -0.89332784    ,2.04285074    ,3.96531105,
   -0.95224366    ,2.07820701    ,4.05045738,
   -1.00144328    ,2.11979859    ,4.16297397,
   -1.08881223    ,2.12475044    ,4.14889029,
   -1.19650664    ,2.13176738    ,4.12597022,
   -1.28468937    ,2.15918369    ,4.16295039,
   -1.33168425    ,2.19857191    ,4.27949160,
   -1.38426628    ,2.23467117    ,4.37807099,
   -1.46819315    ,2.25606670    ,4.41017364,
   -1.56963823    ,2.28185503    ,4.44815950,
   -1.67983283    ,2.28783134    ,4.42921674,
   -1.78663882    ,2.32321391    ,4.49032892,
   -1.89072579    ,2.34734158    ,4.53594446,
   -2.05123327    ,2.34228015    ,4.45436188,
   -2.21325135    ,2.36243339    ,4.45394717,
   -2.47788137    ,2.40678827    ,4.46145701),
25,3,byrow=TRUE)

if (k == 5) beta <- matrix(
c(  0.19627955    ,2.11767820    ,5.55345771,
    0.12202552    ,2.13615392    ,5.65142744,
   -0.11931679    ,2.09429030    ,5.42351628,
   -0.29963665    ,2.08716769    ,5.33506310,
   -0.50516098    ,2.05180478    ,5.14266118,
   -0.60938254    ,2.06844307    ,5.17607173,
   -0.71330489    ,2.07857906    ,5.19048009,
   -0.88642541    ,2.05459350    ,5.04176441,
   -0.99413190    ,2.07177445    ,5.06890858,
   -1.07114034    ,2.10269083    ,5.15526968,
   -1.19723266    ,2.10035792    ,5.09922832,
   -1.30113697    ,2.10698924    ,5.09569334,
   -1.48500920    ,2.07965232    ,4.90895647,
   -1.50718003    ,2.14122815    ,5.14305079,
   -1.58405537    ,2.16852377    ,5.22047324,
   -1.72090558    ,2.16740250    ,5.16193676,
   -1.83157990    ,2.18190524    ,5.17225576,
   -1.94762736    ,2.19579911    ,5.17227554,
   -2.05575809    ,2.22906255    ,5.25644348,
   -2.17708483    ,2.24534506    ,5.27215725,
   -2.33347811    ,2.25239401    ,5.22791702,
   -2.48511537    ,2.26822494    ,5.22511943,
   -2.65950215    ,2.28709717    ,5.22053041,
   -2.87779391    ,2.31261394    ,5.21927843,
   -3.19245767    ,2.34198985    ,5.17934776),
25,3,byrow=TRUE)

if (k == 6) beta <- matrix(
c(  0.01128291    ,2.00995524    ,6.11253022,
   -0.24822800    ,1.97466944    ,5.90130480,
   -0.47909669    ,1.95116371    ,5.73342704,
   -0.61372571    ,1.97023376    ,5.77723285,
   -0.72912799    ,1.98825740    ,5.83473457,
   -0.88645129    ,1.99720073    ,5.81912597,
   -1.06586504    ,1.98767486    ,5.71543080,
   -1.17638561    ,2.00234029    ,5.75466583,
   -1.35840307    ,1.98636902    ,5.62372257,
   -1.44607488    ,2.01346061    ,5.71496591,
   -1.52157893    ,2.05112722    ,5.86006551,
   -1.66896844    ,2.06508340    ,5.85499078,
   -1.77485970    ,2.08537995    ,5.90362858,
   -1.90893508    ,2.09017446    ,5.88167890,
   -2.03181375    ,2.10373778    ,5.89045401,
   -2.17853927    ,2.11395692    ,5.87321914,
   -2.32807778    ,2.11297005    ,5.80615545,
   -2.45289663    ,2.12836984    ,5.82436481,
   -2.61001382    ,2.14018771    ,5.80874484,
   -2.76910050    ,2.15862121    ,5.81601157,
   -2.96418916    ,2.15821575    ,5.71945809,
   -3.14814902    ,2.16166632    ,5.65683810,
   -3.34470671    ,2.17345789    ,5.62807216,
   -3.61114444    ,2.15597732    ,5.42860535,
   -3.93872952    ,2.20118411    ,5.47455019),
25,3,byrow=TRUE)

if (k == 7) beta <- matrix(
c(  0.06860052    ,2.04729531    ,7.32044207,
   -0.06002752    ,2.07030249    ,7.43964795,
   -0.25274357    ,2.07100812    ,7.40948903,
   -0.45663817    ,2.06577614    ,7.33243725,
   -0.63740649    ,2.06840127    ,7.29685896,
   -0.81796022    ,2.06173364    ,7.21927801,
   -0.98687709    ,2.07433702    ,7.21949708,
   -1.25953371    ,2.04608340    ,6.95737761,
   -1.34359895    ,2.08638875    ,7.14619825,
   -1.44138557    ,2.09942267    ,7.20420818,
   -1.67015262    ,2.08218153    ,7.01418465,
   -1.79556856    ,2.10707856    ,7.09326806,
   -1.90099151    ,2.12257044    ,7.14509655,
   -2.04709751    ,2.15489200    ,7.23583722,
   -2.17560206    ,2.16989473    ,7.26675695,
   -2.42852507    ,2.16183776    ,7.09062210,
   -2.58505717    ,2.17978229    ,7.11335001,
   -2.73487377    ,2.19317991    ,7.12126224,
   -2.97943889    ,2.18340861    ,6.94589392,
   -3.16847451    ,2.19135427    ,6.90090471,
   -3.40212791    ,2.20254996    ,6.83100282,
   -3.59524832    ,2.21041323    ,6.80145250,
   -3.88096431    ,2.20247114    ,6.61498370,
   -4.21618075    ,2.22981864    ,6.57777796,
   -4.66547440    ,2.22621448    ,6.33744959),
25,3,byrow=TRUE)

if (k == 8) beta <- matrix(
c( -0.30873625    ,1.94105851    ,7.58558894,
   -0.37616355    ,1.98470511    ,7.88260547,
   -0.43207380    ,2.02026268    ,8.13592809,
   -0.44050328    ,2.05849848    ,8.44749760,
   -0.63114752    ,2.06475878    ,8.43493215,
   -0.82153881    ,2.07466205    ,8.43288751,
   -0.81540640    ,2.13506091    ,8.83861031,
   -0.79562169    ,2.19684131    ,9.26570441,
   -1.03649754    ,2.18840002    ,9.13002288,
   -1.14165336    ,2.22549363    ,9.31181518,
   -1.27960830    ,2.25443150    ,9.43736616,
   -1.55813138    ,2.25016766    ,9.26853422,
   -1.85564303    ,2.23078869    ,8.99629840,
   -2.02691776    ,2.24453500    ,9.01562589,
   -2.21997098    ,2.24623636    ,8.94158737,
   -2.43772658    ,2.23912727    ,8.81057459,
   -2.67686406    ,2.23326030    ,8.65451255,
   -2.91474255    ,2.22180407    ,8.46556736,
   -3.23984272    ,2.19782351    ,8.14346749,
   -3.51352605    ,2.19122552    ,7.95867739,
   -3.77075135    ,2.19799860    ,7.86574804,
   -4.01935266    ,2.20267150    ,7.78182739,
   -4.36843426    ,2.18556565    ,7.49670216,
   -4.68221352    ,2.21156322    ,7.49727826,
   -5.25661230    ,2.20427576    ,7.13197529),
25,3,byrow=TRUE)

if (k == 9) beta <- matrix(
c( -0.04323655    ,2.01248457    ,9.15231011,
   -0.27543147    ,2.01498672    ,9.14911395,
   -0.19895631    ,2.07992587    ,9.71492628,
   -0.53139081    ,2.06649334    ,9.50289336,
   -0.63401205    ,2.10316678    ,9.74452254,
   -0.84730449    ,2.11983424    ,9.77892436,
   -1.13672160    ,2.11384414    ,9.61428400,
   -1.46163013    ,2.09998820    ,9.37231814,
   -1.71729249    ,2.10130175    ,9.26957429,
   -1.98857591    ,2.10248754    ,9.13472590,
   -2.16092383    ,2.11842908    ,9.17728332,
   -2.38940263    ,2.11943919    ,9.08987259,
   -2.58363191    ,2.12314517    ,9.03287776,
   -2.73901739    ,2.15262515    ,9.16504301,
   -2.97150283    ,2.14852965    ,9.02100857,
   -3.22379889    ,2.16262866    ,8.97815298,
   -3.38008096    ,2.18590052    ,9.07198442,
   -3.58424345    ,2.19826545    ,9.06067942,
   -3.84873769    ,2.20038122    ,8.93549467,
   -4.12255856    ,2.19520581    ,8.76316693,
   -4.49966040    ,2.16704028    ,8.36109318,
   -4.76421575    ,2.18576059    ,8.35199208,
   -5.07475390    ,2.19569977    ,8.27407472,
   -5.40128020    ,2.22224708    ,8.30862285,
   -6.07633496    ,2.16651948    ,7.58255943),
25,3,byrow=TRUE)

if (k == 10) beta <- matrix(
c( -0.59026995    ,1.91637970    ,9.13759734,
   -0.78888686    ,1.91806316    ,9.17211552,
   -0.84169141    ,1.95904411    ,9.52459312,
   -1.12914513    ,1.95663159    ,9.41638240,
   -1.08429498    ,2.01705226    ,9.95373894,
   -1.31435606    ,2.02054195    ,9.91318324,
   -1.65969814    ,2.00115830    ,9.62324917,
   -1.77772078    ,2.03437224    ,9.83874792,
   -2.02896630    ,2.03622184    ,9.74723831,
   -2.31914081    ,2.03133644    ,9.56683933,
   -2.55772924    ,2.02923980    ,9.45546065,
   -2.78358214    ,2.03069759    ,9.37670649,
   -3.08245359    ,2.00138005    ,9.03065740,
   -3.33261351    ,1.99957500    ,8.90224955,
   -3.54685337    ,2.02277824    ,8.95169831,
   -3.67675223    ,2.06875822    ,9.23340784,
   -3.82951847    ,2.10647889    ,9.44447347,
   -4.03467984    ,2.11158946    ,9.39679396,
   -4.29508169    ,2.11716815    ,9.31779120,
   -4.58778186    ,2.11669157    ,9.16551866,
   -4.88391912    ,2.14763479    ,9.21982263,
   -5.14793945    ,2.17621108    ,9.29984689,
   -5.56144018    ,2.16408565    ,8.99186486,
   -6.05261985    ,2.16169698    ,8.69587246,
   -6.73903932    ,2.17119194    ,8.36835868),
25,3,byrow=TRUE)

if (k == 11) beta <- matrix(
c( -0.62365989    ,1.91857722   ,10.07497237,
   -0.89604060    ,1.91882620   ,10.04670290,
   -0.99732050    ,1.96916523   ,10.45644253,
   -0.93543882    ,2.03557084   ,11.10706791,
   -1.29637208    ,2.02602333   ,10.89544026,
   -1.35312996    ,2.07845905   ,11.33833970,
   -1.28414089    ,2.15744117   ,12.06025845,
   -1.44058975    ,2.17912481   ,12.20864907,
   -1.96889323    ,2.14413407   ,11.64830461,
   -2.50670568    ,2.08634945   ,10.90192363,
   -3.04918653    ,2.03511630   ,10.19290619,
   -3.06950410    ,2.10267432   ,10.75284230,
   -3.12552810    ,2.15056204   ,11.14025623,
   -3.43854805    ,2.15087381   ,10.97856592,
   -3.75939697    ,2.13945316   ,10.71561697,
   -4.08057561    ,2.13235535   ,10.49425156,
   -4.44770759    ,2.11800541   ,10.17193509,
   -4.66068165    ,2.14833682   ,10.30022638,
   -4.93054730    ,2.17478384   ,10.37062653,
   -5.01719254    ,2.22896256   ,10.81004069,
   -5.49626725    ,2.17882135   ,10.14554086,
   -5.86716231    ,2.17804796    ,9.94116167,
   -6.20765269    ,2.22742572   ,10.14983611,
   -6.74667468    ,2.20600859    ,9.69646677,
   -7.48958545    ,2.24609155    ,9.59773214),
25,3,byrow=TRUE)

if (k == 12) beta <- matrix(
c( -0.39819155    ,1.96444000   ,11.53879914,
   -0.48811015    ,1.99739099   ,11.92276025,
   -0.87102334    ,1.98004703   ,11.68989516,
   -0.99818845    ,2.01059648   ,11.97801352,
   -1.41473828    ,1.98134442   ,11.58399326,
   -1.65150107    ,1.99833250   ,11.65220487,
   -1.90971392    ,2.00765773   ,11.63739024,
   -2.24058618    ,2.00281312   ,11.44776001,
   -2.83435553    ,1.96384446   ,10.77530849,
   -2.90747319    ,2.01590373   ,11.20363680,
   -3.21918878    ,2.01470566   ,11.03420836,
   -3.48055970    ,2.02166225   ,10.97949408,
   -3.78522248    ,2.01091331   ,10.74048354,
   -4.01708232    ,2.02796294   ,10.78162966,
   -4.31902952    ,2.02510818   ,10.59440717,
   -4.68759947    ,2.03175207   ,10.42871360,
   -4.96780537    ,2.03926451   ,10.35184906,
   -5.20162379    ,2.07125608   ,10.49479632,
   -5.45507483    ,2.08738675   ,10.52332734,
   -5.79562957    ,2.08067196   ,10.29145789,
   -6.05926263    ,2.09836325   ,10.33588441,
   -6.47248298    ,2.08406268    ,9.99287115,
   -6.85596659    ,2.11228288   ,10.03136263,
   -7.40092146    ,2.10175578    ,9.64879834,
   -8.19400757    ,2.09960665    ,9.17540191),
25,3,byrow=TRUE)

if (k == 13) beta <- matrix(
c( -1.46326129    ,1.79825368   ,10.41684137,
   -1.45237427    ,1.84424961   ,10.99627097,
   -1.73114642    ,1.84229620   ,10.94946411,
   -2.06951705    ,1.84501386   ,10.86712854,
   -2.17171595    ,1.89645772   ,11.33782181,
   -2.03826979    ,1.97089824   ,12.19301524,
   -2.23787623    ,2.00596021   ,12.44290967,
   -2.55099533    ,2.00739487   ,12.32404115,
   -2.87902336    ,2.01137258   ,12.21525101,
   -2.90219738    ,2.05731060   ,12.69423210,
   -3.30786288    ,2.04313934   ,12.35386194,
   -3.77261976    ,2.01249898   ,11.83258893,
   -4.16193914    ,1.99667797   ,11.47517661,
   -4.40416303    ,2.02848458   ,11.64539190,
   -4.60698882    ,2.04886857   ,11.74304504,
   -4.93519853    ,2.03283470   ,11.44780129,
   -5.23844331    ,2.02572171   ,11.24303922,
   -5.49275767    ,2.04442714   ,11.28869335,
   -5.83373602    ,2.04486143   ,11.12177845,
   -6.18406416    ,2.05378723   ,11.01275260,
   -6.45823439    ,2.10233331   ,11.30901959,
   -6.93923686    ,2.10286924   ,11.02285983,
   -7.38723927    ,2.11969794   ,10.93118131,
   -8.07680541    ,2.07068329   ,10.08068307,
   -8.89268249    ,2.06793445    ,9.59833171),
25,3,byrow=TRUE)

if (k == 14) beta <- matrix(
c( -0.51375043    ,1.94773025   ,13.27196461,
   -0.53363278    ,1.99938651   ,13.93520385,
   -1.58054624    ,1.91805045   ,12.60250809,
   -1.28632696    ,2.02544526   ,13.93586138,
   -1.46151833    ,2.05149718   ,14.19840880,
   -1.44156324    ,2.10387707   ,14.84315578,
   -1.66692703    ,2.11946880   ,14.95648757,
   -2.15354962    ,2.10549876   ,14.56987653,
   -2.75244278    ,2.08823200   ,14.04746683,
   -2.86043285    ,2.12552473   ,14.41641144,
   -3.07592003    ,2.14898223   ,14.57439480,
   -3.29929553    ,2.17079982   ,14.71451440,
   -3.68344546    ,2.17279059   ,14.52286280,
   -3.95930435    ,2.19155536   ,14.58667619,
   -4.26005028    ,2.19568417   ,14.48666336,
   -4.77997724    ,2.16844382   ,13.91765240,
   -5.40181266    ,2.12213957   ,13.07427044,
   -5.55515654    ,2.16577246   ,13.45347527,
   -6.11858768    ,2.13570785   ,12.81646448,
   -6.59942857    ,2.13727791   ,12.53400805,
   -6.91257138    ,2.19030651   ,12.88579717,
   -7.40293259    ,2.20077524   ,12.70765504,
   -7.78893210    ,2.24858647   ,12.99384328,
   -8.51660901    ,2.21293961   ,12.22882972,
   -9.65441609    ,2.15534971   ,10.96237775),
25,3,byrow=TRUE)

if (k == 15) beta <- matrix(
c(  0.02976106    ,2.06599657   ,15.68923616,
   -0.49633841    ,2.06433063   ,15.50536283,
   -0.61458891    ,2.09393365   ,15.91962029,
   -1.82388242    ,1.99575745   ,14.24141290,
   -2.03272019    ,2.03275658   ,14.57903247,
   -2.49471016    ,2.02200093   ,14.26872531,
   -2.83126547    ,2.03820085   ,14.28928745,
   -3.56689879    ,1.98039773   ,13.28726144,
   -3.82973264    ,1.99744873   ,13.37505205,
   -4.12041969    ,2.00817107   ,13.35487918,
   -4.41921674    ,2.02797769   ,13.40608732,
   -4.89864804    ,2.00062084   ,12.88349512,
   -5.27342403    ,2.00187491   ,12.69366330,
   -5.51832859    ,2.02937674   ,12.87114928,
   -5.78291064    ,2.04829677   ,12.93671118,
   -6.06878278    ,2.07491420   ,13.06890945,
   -6.37635838    ,2.08798948   ,13.05474466,
   -6.66123413    ,2.10863845   ,13.12802116,
   -7.04190606    ,2.12580935   ,13.09697678,
   -7.34971911    ,2.14941716   ,13.19483161,
   -7.89580958    ,2.11917359   ,12.56119109,
   -8.37333924    ,2.12266550   ,12.32911489,
   -8.96852578    ,2.12849815   ,12.03550775,
   -9.58000343    ,2.11984379   ,11.62458359,
  -10.51211077    ,2.06546327   ,10.55645975),
25,3,byrow=TRUE)

if (k == 16) beta <- matrix(
c( -0.38974549    ,1.96526199   ,15.57140748,
   -0.71179002    ,1.97894451   ,15.72325320,
   -1.14613735    ,1.97550962   ,15.57923085,
   -1.46871545    ,1.98814753   ,15.65237089,
   -2.27214792    ,1.94380738   ,14.73756599,
   -2.32067089    ,1.99756755   ,15.40071295,
   -2.51933064    ,2.03857606   ,15.79747847,
   -2.48202476    ,2.11212325   ,16.71357386,
   -2.61789952    ,2.16430789   ,17.28071878,
   -2.86114137    ,2.19113467   ,17.48562078,
   -3.80517146    ,2.13015896   ,16.19029090,
   -4.44230553    ,2.11974503   ,15.66843316,
   -4.81575740    ,2.12757095   ,15.55655921,
   -5.21608918    ,2.13085190   ,15.38479121,
   -5.76333251    ,2.09775573   ,14.69471849,
   -6.16352060    ,2.11103541   ,14.61281391,
   -6.56593879    ,2.11271397   ,14.40562323,
   -6.92233210    ,2.10938011   ,14.18991387,
   -7.39624708    ,2.09807714   ,13.80092022,
   -7.88171088    ,2.10552783   ,13.59115037,
   -8.44204212    ,2.07457352   ,12.93224874,
   -9.00002430    ,2.05039740   ,12.34554570,
   -9.63071123    ,2.00745645   ,11.51104575,
  -10.21385701    ,2.01445197   ,11.28260494,
  -11.25503879    ,2.00229298   ,10.51466866),
25,3,byrow=TRUE)

if (k == 17) beta <- matrix(
c( -0.20237304    ,2.02427972   ,17.23630313,
   -0.70755051    ,2.03639245   ,17.23519069,
   -0.86782478    ,2.07021441   ,17.71726539,
   -1.35383915    ,2.07044711   ,17.54292865,
   -1.36846845    ,2.12891608   ,18.34415945,
   -1.60655213    ,2.15626618   ,18.63460302,
   -1.98731252    ,2.16842679   ,18.62861382,
   -2.52870675    ,2.15459067   ,18.19736301,
   -3.09927772    ,2.14098124   ,17.74023231,
   -3.70679400    ,2.12843814   ,17.22814616,
   -4.29782472    ,2.10707196   ,16.63536449,
   -4.83269263    ,2.10108846   ,16.26280448,
   -5.34478740    ,2.09007526   ,15.82988108,
   -5.91150436    ,2.07745257   ,15.34048362,
   -6.49839455    ,2.03338542   ,14.48338354,
   -6.95471541    ,2.03467636   ,14.23182539,
   -7.35339115    ,2.03742285   ,14.04594655,
   -7.58056409    ,2.07988244   ,14.43289540,
   -8.02121118    ,2.08790349   ,14.28970519,
   -8.39603392    ,2.13429524   ,14.61372092,
   -8.58674749    ,2.21920365   ,15.54088652,
   -9.35171723    ,2.16973959   ,14.48955561,
  -10.07279131    ,2.11097453   ,13.39310413,
  -10.66569027    ,2.13119681   ,13.33256681,
  -11.88612939    ,2.12758603   ,12.52746798),
25,3,byrow=TRUE)

if (k == 18) beta <- matrix(
c(  0.84455899    ,2.07816010   ,19.69296256,
   -0.23006559    ,2.02978409   ,18.61179137,
   -1.47163663    ,1.96552161   ,17.15483811,
   -2.14887820    ,1.95204043   ,16.67283111,
   -2.62266859    ,1.96003388   ,16.56862497,
   -3.16205255    ,1.95768975   ,16.26806208,
   -3.58198447    ,1.97145463   ,16.24061434,
   -4.05438843    ,1.96160208   ,15.91017304,
   -4.68020013    ,1.93546182   ,15.25047508,
   -5.23004717    ,1.92319594   ,14.77945683,
   -5.21313811    ,2.00391039   ,15.83532840,
   -5.35560493    ,2.04312661   ,16.30653639,
   -5.95613999    ,2.00251702   ,15.47313935,
   -6.43622554    ,1.99624602   ,15.13206056,
   -6.85856141    ,1.97713051   ,14.69047106,
   -7.35101775    ,1.94983783   ,14.09261883,
   -7.81520325    ,1.93219069   ,13.62388699,
   -8.15325008    ,1.93614845   ,13.50372176,
   -8.74048902    ,1.89852462   ,12.70825350,
   -9.08725656    ,1.94618647   ,13.09271663,
   -9.59171607    ,1.93655539   ,12.68817255,
  -10.11883388    ,1.95125352   ,12.56591716,
  -10.62183678    ,1.99840771   ,12.85783878,
  -11.39821347    ,2.02804381   ,12.74619676,
  -12.56752448    ,1.98403337   ,11.51481175),
25,3,byrow=TRUE)

if (k == 19) beta <- matrix(
c( -1.67128017    ,1.87448051   ,16.36432152,
   -2.20680867    ,1.86562259   ,16.14606463,
   -3.13589216    ,1.79616732   ,14.88091376,
   -3.47551527    ,1.82555601   ,15.14488752,
   -3.90749722    ,1.82428020   ,14.98714545,
   -3.99063168    ,1.87550773   ,15.69134777,
   -4.39048612    ,1.89667717   ,15.76390752,
   -4.46995214    ,1.95580767   ,16.54192576,
   -5.27643139    ,1.91976818   ,15.61146984,
   -5.46835338    ,1.95046227   ,15.95673519,
   -5.66829218    ,1.99003583   ,16.40769678,
   -6.12282211    ,1.99427449   ,16.22236577,
   -6.51241570    ,1.98743936   ,15.95292502,
   -7.09318873    ,1.94900810   ,15.15563059,
   -7.46518049    ,1.94297149   ,14.90368818,
   -7.99396435    ,1.91277804   ,14.22942291,
   -8.31653732    ,1.94270160   ,14.44096208,
   -8.77892414    ,1.92603583   ,13.97185104,
   -9.30708587    ,1.92370322   ,13.62435381,
   -9.66382709    ,1.97163637   ,14.03510966,
   -9.98001718    ,2.02726919   ,14.59955301,
  -10.65531591    ,1.97009689   ,13.47886945,
  -11.25889970    ,1.97674109   ,13.22151131,
  -12.05159318    ,1.95979152   ,12.54167423,
  -13.17064806    ,2.01410922   ,12.56106152),
25,3,byrow=TRUE)

if (k == 20) beta <- matrix(
c(  0.56226508    ,2.07065668   ,21.47237913,
   -0.04777826    ,2.06215084   ,21.23529320,
   -1.56892986    ,1.98638394   ,19.34416090,
   -2.14818732    ,1.99447058   ,19.21034185,
   -2.60982280    ,2.00570049   ,19.18673868,
   -3.26195964    ,2.00528429   ,18.83190784,
   -3.53470698    ,2.02925574   ,19.10498900,
   -4.16702766    ,2.01330081   ,18.55556393,
   -4.90974788    ,1.99148652   ,17.82899414,
   -5.29282649    ,2.00879825   ,17.87359619,
   -5.74462669    ,2.01530925   ,17.72505246,
   -6.12849195    ,2.03336992   ,17.77480216,
   -6.42681387    ,2.06280088   ,18.01779907,
   -6.89313727    ,2.07446468   ,17.92069137,
   -7.29141672    ,2.06693072   ,17.63584256,
   -7.84055488    ,2.06464863   ,17.28177298,
   -8.38222967    ,2.03866489   ,16.64284413,
   -8.96368910    ,2.02143495   ,16.05934545,
   -9.52777045    ,2.00924330   ,15.57317263,
  -10.11382797    ,1.98599353   ,14.91688639,
  -10.71333868    ,1.96636384   ,14.30566861,
  -11.26869701    ,1.98470249   ,14.23179665,
  -11.91084459    ,2.00191189   ,14.08480644,
  -12.62109661    ,2.02532088   ,14.01090492,
  -13.83958240    ,2.02969919   ,13.35644448),
25,3,byrow=TRUE)

if (k == 21) beta <- matrix(
c(  1.13290846    ,2.12375423   ,23.67146935,
    0.89703063    ,2.15559139   ,24.27092447,
    0.56712965    ,2.18130746   ,24.66145223,
   -0.70243818    ,2.13282315   ,23.25916098,
   -2.05507976    ,2.07879084   ,21.66596321,
   -2.95193311    ,2.06498021   ,20.93682891,
   -3.86590360    ,2.03948882   ,20.02517352,
   -4.21048661    ,2.06978477   ,20.31490543,
   -4.47109642    ,2.10670212   ,20.76857362,
   -4.93789634    ,2.10205094   ,20.47751210,
   -5.17849161    ,2.13933228   ,20.92784725,
   -5.67989741    ,2.14531999   ,20.74948429,
   -6.76912383    ,2.06071397   ,18.85495208,
   -7.30407354    ,2.06235004   ,18.56872189,
   -7.59142350    ,2.09525059   ,18.89998633,
   -7.95979471    ,2.12617385   ,19.15371036,
   -8.48568664    ,2.12474478   ,18.83855149,
   -8.90257536    ,2.13592724   ,18.77330812,
   -9.84238960    ,2.05131185   ,16.98920825,
  -10.58083056    ,2.02932282   ,16.20500619,
  -11.08718256    ,2.05422365   ,16.27228790,
  -11.68566309    ,2.07924548   ,16.27392038,
  -12.38761123    ,2.09741548   ,16.10731150,
  -13.35406944    ,2.08384252   ,15.32576854,
  -14.72888546    ,2.06269021   ,14.19009583),
25,3,byrow=TRUE)

if (k == 22) beta <- matrix(
c( -1.05126457    ,1.98074586   ,21.02915371,
   -1.74073669    ,1.97578151   ,20.76630019,
   -2.40607929    ,1.98071137   ,20.57734142,
   -2.56149214    ,2.02403966   ,21.29708300,
   -3.35614082    ,2.00528662   ,20.63771253,
   -3.75283911    ,2.03028783   ,20.85385280,
   -4.18312159    ,2.04334718   ,20.88373783,
   -4.38781768    ,2.07899644   ,21.38937743,
   -5.15570152    ,2.06033204   ,20.67432754,
   -5.83029103    ,2.03412302   ,19.91488799,
   -6.34127938    ,2.03239169   ,19.62919845,
   -6.99045637    ,2.01097760   ,18.95740222,
   -7.37269132    ,2.02562896   ,18.97359036,
   -7.86415286    ,2.03564611   ,18.84588988,
   -8.33527312    ,2.04505425   ,18.71355471,
   -8.79498425    ,2.06681990   ,18.77241314,
   -9.53086086    ,2.04857197   ,18.02758125,
   -9.91956050    ,2.06310660   ,18.04892040,
  -10.25938485    ,2.08031601   ,18.17466075,
  -10.98259697    ,2.03939978   ,17.13791005,
  -11.66912201    ,2.00525827   ,16.23901114,
  -12.19766455    ,2.02894826   ,16.30726800,
  -12.83792066    ,2.07000497   ,16.53612929,
  -13.81148756    ,2.07185287   ,15.96660918,
  -15.21308785    ,2.11120107   ,15.68984140),
25,3,byrow=TRUE)

if (k == 23) beta <- matrix(
c(  2.54054652    ,2.22228852   ,28.39914107,
    0.82701824    ,2.15001973   ,26.40301866,
   -0.99456938    ,2.06302897   ,24.01401655,
   -0.95119007    ,2.12562180   ,25.22479577,
   -2.19989529    ,2.09179939   ,23.93901732,
   -2.82327935    ,2.09524607   ,23.71024697,
   -3.79848309    ,2.07805397   ,22.84229165,
   -4.14313374    ,2.11394936   ,23.25742773,
   -4.33506501    ,2.16405513   ,24.01002798,
   -4.76435716    ,2.17589366   ,23.99902869,
   -5.55637797    ,2.14955266   ,23.12165980,
   -5.87957760    ,2.19784012   ,23.70982256,
   -5.45723092    ,2.30981921   ,25.86650867,
   -6.32542789    ,2.28903345   ,24.99244484,
   -7.19605073    ,2.27329143   ,24.16380050,
   -7.75977190    ,2.28152685   ,23.96773512,
   -8.51764713    ,2.26663683   ,23.26545750,
   -9.62431215    ,2.19525793   ,21.41582378,
   -9.94327546    ,2.26234192   ,22.31863274,
  -10.92145697    ,2.21672359   ,20.96350912,
  -11.57331323    ,2.22386049   ,20.69749530,
  -12.50466466    ,2.19092079   ,19.59662537,
  -13.48718891    ,2.18431483   ,18.86238246,
  -14.67051044    ,2.13284084   ,17.32520399,
  -16.28370099    ,2.04470389   ,14.95063697),
25,3,byrow=TRUE)

if (k == 24) beta <- matrix(
c( -1.10396119    ,1.89403285   ,21.90099212,
   -1.88956673    ,1.88348303   ,21.49094497,
   -2.55283259    ,1.89442381   ,21.39972146,
   -2.71557278    ,1.94593260   ,22.27646047,
   -3.21146895    ,1.95985837   ,22.31234522,
   -3.89232089    ,1.94709743   ,21.79937823,
   -4.17796923    ,1.97869564   ,22.24239439,
   -4.65964991    ,1.99796009   ,22.31843949,
   -4.61568245    ,2.06486447   ,23.55365875,
   -5.48716758    ,2.02849894   ,22.45337304,
   -6.77141913    ,1.94227211   ,20.25195258,
   -8.03711108    ,1.86633001   ,18.20192038,
   -8.40076215    ,1.90898192   ,18.64779833,
   -9.21042557    ,1.88619163   ,17.76541017,
   -9.60243876    ,1.90220315   ,17.80879060,
  -10.12097174    ,1.91467045   ,17.70472325,
  -10.62214659    ,1.92484327   ,17.57267846,
  -10.95103780    ,1.95541117   ,17.89956485,
  -11.71479731    ,1.91975938   ,16.86125843,
  -12.26968279    ,1.90635323   ,16.34162737,
  -12.90974250    ,1.84280673   ,15.00004586,
  -13.49462609    ,1.85191241   ,14.81750654,
  -14.16999418    ,1.83482548   ,14.17101083,
  -14.99410859    ,1.83487417   ,13.70083718,
  -16.28832957    ,1.83405924   ,12.90346573),
25,3,byrow=TRUE)

if (k == 25) beta <- matrix(
c(  0.05343857    ,2.02784402   ,25.72546182,
   -0.84884486    ,2.01673209   ,25.23030685,
   -1.70071485    ,2.01987294   ,24.90712058,
   -2.21648901    ,2.03988661   ,25.08004595,
   -2.63736527    ,2.06173506   ,25.33393981,
   -3.90313394    ,2.03492440   ,24.07467369,
   -5.50950839    ,1.95198374   ,21.66817917,
   -6.03695584    ,1.96830374   ,21.66255981,
   -6.66627196    ,1.97588769   ,21.43837171,
   -7.30256162    ,1.95874526   ,20.81289794,
   -7.92872057    ,1.94012219   ,20.16912318,
   -8.63306382    ,1.92156355   ,19.45100486,
   -9.26775364    ,1.90905333   ,18.86225120,
   -9.84305994    ,1.91417868   ,18.60138510,
  -10.72921784    ,1.84643324   ,16.93523007,
  -11.24149674    ,1.86040243   ,16.86343597,
  -11.74065917    ,1.86396516   ,16.63992117,
  -12.17923782    ,1.88294675   ,16.70485644,
  -12.67617557    ,1.89310385   ,16.60422083,
  -13.21769540    ,1.89801289   ,16.37797995,
  -13.73826644    ,1.89382260   ,16.04734456,
  -14.32931604    ,1.90418974   ,15.89012609,
  -15.05332438    ,1.92366559   ,15.79228569,
  -16.03855224    ,1.93188150   ,15.32325057,
  -17.49597299    ,1.96978519   ,15.04418676),
25,3,byrow=TRUE)

if (k == 26) beta <- matrix(
c( -1.10875560    ,1.97252341   ,24.84029809,
   -1.22478350    ,2.03110054   ,26.06085214,
   -2.09283214    ,2.02270669   ,25.58049006,
   -3.20960415    ,2.01118807   ,24.75786679,
   -3.84004314    ,2.01200817   ,24.53834102,
   -4.48609036    ,2.01451128   ,24.28393746,
   -4.86314088    ,2.02768920   ,24.42131939,
   -5.67230258    ,2.01838954   ,23.80002436,
   -6.06166468    ,2.03649853   ,23.98836932,
   -7.02106744    ,2.00509632   ,22.85032844,
   -7.26411554    ,2.05368283   ,23.59750615,
   -7.78553019    ,2.07831064   ,23.72713219,
   -8.19713096    ,2.09348626   ,23.80881939,
   -8.90916758    ,2.08614852   ,23.26515337,
   -9.57697370    ,2.08429022   ,22.81203792,
  -10.43177291    ,2.04840129   ,21.67606732,
  -10.76373514    ,2.08504099   ,22.16410561,
  -11.49694380    ,2.06248625   ,21.32521592,
  -12.21495697    ,2.04955494   ,20.66834698,
  -12.92143882    ,2.05052563   ,20.25261789,
  -13.66092414    ,2.04206533   ,19.66014492,
  -14.35922683    ,2.05208990   ,19.43326002,
  -15.35773855    ,2.03512599   ,18.49639131,
  -16.53124893    ,1.97732861   ,16.77585824,
  -18.08951416    ,1.92390177   ,14.90131942),
25,3,byrow=TRUE)

if (k == 27) beta <- matrix(
c( -1.94125821    ,1.92007209   ,24.32267933,
   -2.35120929    ,1.94616805   ,24.82449247,
   -1.34343660    ,2.08681499   ,28.27775885,
   -1.34248235    ,2.13911898   ,29.47244439,
   -1.48665349    ,2.18023372   ,30.33475609,
   -1.71016716    ,2.22004975   ,31.08808619,
   -3.43695875    ,2.15530386   ,28.80084560,
   -4.41670400    ,2.14613934   ,28.03225153,
   -5.62154265    ,2.12546555   ,26.87458083,
   -6.68272723    ,2.09417525   ,25.63803249,
   -7.83186040    ,2.05113227   ,24.12599799,
   -8.22630820    ,2.08519709   ,24.55363665,
   -9.23151304    ,2.04964494   ,23.26332330,
   -9.75736812    ,2.07075967   ,23.35618541,
  -10.23054843    ,2.07547690   ,23.20660123,
  -10.83842814    ,2.10028890   ,23.28407697,
  -11.09494365    ,2.13660637   ,23.87883144,
  -11.82668635    ,2.12114707   ,23.16110568,
  -12.72308123    ,2.08784791   ,22.00464588,
  -13.54266661    ,2.06271584   ,21.04409585,
  -14.44177144    ,2.03811877   ,20.02837621,
  -15.36136789    ,2.04402346   ,19.52558449,
  -16.20823079    ,2.04037553   ,18.97580383,
  -17.27934490    ,2.07733474   ,18.96854111,
  -18.98810218    ,1.95900991   ,15.80205275),
25,3,byrow=TRUE)

if (k == 28) beta <- matrix(
c( -1.25858377    ,1.96758100   ,26.66843417,
   -2.46504052    ,1.92992361   ,25.50937387,
   -3.37753937    ,1.92728198   ,25.05086362,
   -4.24089191    ,1.92490761   ,24.59554896,
   -5.45828378    ,1.88701816   ,23.21981025,
   -6.00792903    ,1.90079392   ,23.24207299,
   -6.60112516    ,1.90322687   ,23.01997951,
   -6.59389599    ,1.97020584   ,24.38251645,
   -7.34949748    ,1.96243186   ,23.82716977,
   -7.92450035    ,1.97272279   ,23.68900698,
   -8.61339746    ,1.98235790   ,23.44399867,
   -9.40631958    ,1.96393352   ,22.63736828,
   -9.26452927    ,2.06468909   ,24.65528907,
   -9.86229634    ,2.07635163   ,24.53154110,
  -11.01154607    ,2.01408897   ,22.61336460,
  -12.05821147    ,1.95069212   ,20.78412258,
  -12.68796751    ,1.93941632   ,20.20944258,
  -13.10887254    ,1.99205906   ,20.91594955,
  -13.95920456    ,1.96160573   ,19.82270958,
  -14.58592923    ,1.98487012   ,19.86572045,
  -15.39340778    ,1.95603989   ,18.84274886,
  -16.22969745    ,1.90701582   ,17.45979720,
  -17.06470847    ,1.94070749   ,17.56318184,
  -18.09412396    ,1.90833913   ,16.36160486,
  -19.70887735    ,1.91662776   ,15.50435646),
25,3,byrow=TRUE)

if (k == 29) beta <- matrix(
c( -1.22450738    ,1.95289895   ,27.48022361,
   -2.56259961    ,1.91981280   ,26.27547623,
   -3.31653110    ,1.92479934   ,26.10496301,
   -4.30682435    ,1.89673752   ,25.14009720,
   -5.79210526    ,1.83684425   ,23.13049443,
   -6.83941492    ,1.79811073   ,21.82977790,
   -7.15777613    ,1.84111557   ,22.51930106,
   -7.47129354    ,1.87252978   ,23.02251554,
   -8.11232911    ,1.87805505   ,22.78737200,
   -8.35753837    ,1.92102544   ,23.52147717,
   -9.26760363    ,1.88985690   ,22.37710616,
  -10.07563333    ,1.87952395   ,21.68215700,
  -10.57368760    ,1.87666275   ,21.37460646,
  -10.98481247    ,1.92142475   ,21.98436557,
  -11.52218607    ,1.91520422   ,21.57606547,
  -12.32835460    ,1.91212737   ,20.98255495,
  -12.76790072    ,1.95835091   ,21.60536163,
  -13.28080540    ,1.98652816   ,21.83882266,
  -13.47720721    ,2.09088036   ,23.76961650,
  -14.37500335    ,2.06711698   ,22.74394494,
  -15.01509416    ,2.09354672   ,22.88464091,
  -16.22884254    ,2.01813821   ,20.65500179,
  -17.23375795    ,2.05814201   ,20.74284722,
  -18.35770040    ,2.09318385   ,20.72508400,
  -20.14685069    ,1.99635585   ,17.78846638),
25,3,byrow=TRUE)

if (k == 30) beta <- matrix(
c( -2.37587367    ,1.87907307   ,26.14947046,
   -3.95422324    ,1.82936738   ,24.42516450,
   -4.55104658    ,1.84797052   ,24.62078482,
   -5.49484090    ,1.83232265   ,23.88389491,
   -6.38755891    ,1.82912134   ,23.34285900,
   -7.55337590    ,1.78134950   ,21.76424137,
   -7.98685388    ,1.82115100   ,22.31912452,
   -8.47340194    ,1.84766287   ,22.58787399,
   -8.87315504    ,1.87600505   ,22.98303565,
   -9.87605563    ,1.83481906   ,21.56483141,
  -10.81396541    ,1.79318706   ,20.19754452,
  -11.16613697    ,1.82208912   ,20.61223143,
  -11.25150578    ,1.88788691   ,21.91580398,
  -11.35566102    ,1.94500487   ,23.08132686,
  -12.18169769    ,1.90217666   ,21.75417005,
  -13.33985190    ,1.82163074   ,19.44300858,
  -13.88993215    ,1.85875722   ,19.80733373,
  -14.18742969    ,1.92802388   ,20.99273178,
  -14.93974870    ,1.91741144   ,20.33290170,
  -15.60063505    ,1.93446718   ,20.26041800,
  -16.28429100    ,1.97001129   ,20.52024952,
  -17.25134594    ,1.91995317   ,18.94783892,
  -18.16493106    ,1.91436968   ,18.28656786,
  -19.16452862    ,1.94168772   ,18.24283542,
  -20.92388843    ,1.90498884   ,16.41599763),
25,3,byrow=TRUE)

if (k == 31) beta <- matrix(
c(  3.20936590    ,2.19126614   ,37.56899046,
    2.52195246    ,2.22323373   ,38.10592674,
    2.00463535    ,2.27100434   ,38.97924216,
   -0.24192758    ,2.21393571   ,36.36855730,
   -1.76914651    ,2.18121939   ,34.79657793,
   -3.18216141    ,2.15847989   ,33.44933125,
   -4.59048513    ,2.13452305   ,32.05234605,
   -5.93734844    ,2.10835569   ,30.64150877,
   -6.85663078    ,2.10352330   ,30.01509180,
   -7.79086438    ,2.08209749   ,29.02872127,
   -8.35148549    ,2.10192830   ,29.14413623,
   -9.25153092    ,2.10739620   ,28.67295361,
   -8.96253871    ,2.18696790   ,30.67045225,
  -10.05534172    ,2.16412960   ,29.48578611,
  -10.51475651    ,2.18502558   ,29.68656179,
  -11.98556145    ,2.10348342   ,27.02787481,
  -13.05552876    ,2.06049218   ,25.45779042,
  -14.11937571    ,2.02621266   ,24.02828039,
  -15.37354761    ,1.95245547   ,21.69023315,
  -16.05409404    ,1.98591827   ,21.93455608,
  -16.95378341    ,1.94945167   ,20.64491319,
  -17.72328828    ,1.97299540   ,20.65528274,
  -18.64613501    ,1.97398189   ,20.12778183,
  -19.85846191    ,1.97647364   ,19.42370496,
  -21.74244021    ,1.91929241   ,17.06800649),
25,3,byrow=TRUE)

if (k == 32) beta <- matrix(
c( -1.29370623    ,1.94583536   ,30.26677171,
   -2.80839550    ,1.91343826   ,28.89095397,
   -5.07856490    ,1.82566738   ,25.71641718,
   -6.64350776    ,1.76207713   ,23.54435106,
   -7.22575761    ,1.78440439   ,23.75195155,
   -7.75967244    ,1.81619133   ,24.15344906,
   -8.48182523    ,1.82356971   ,23.91660531,
   -8.39032299    ,1.90249126   ,25.74227123,
   -9.23056457    ,1.87966670   ,24.83847494,
   -9.64042158    ,1.90538224   ,25.18784806,
   -9.37578058    ,1.98542281   ,27.19211080,
  -10.47742386    ,1.94776922   ,25.71862758,
  -11.41238214    ,1.92256979   ,24.59108910,
  -12.10271201    ,1.91870716   ,24.11634532,
  -12.81032440    ,1.90217651   ,23.35875248,
  -13.23755334    ,1.94779513   ,24.08315449,
  -13.99011611    ,1.94811117   ,23.61379419,
  -14.70868859    ,1.92514431   ,22.71714667,
  -15.08347849    ,2.00113703   ,24.10808384,
  -15.89698630    ,1.97333657   ,23.05163722,
  -16.62083418    ,2.01631280   ,23.48865831,
  -17.42784145    ,2.03916100   ,23.48456264,
  -18.48013583    ,2.04045064   ,22.84170841,
  -19.95828542    ,2.01406726   ,21.31116813,
  -22.00016019    ,1.98850822   ,19.45210594),
25,3,byrow=TRUE)

if (k == 33) beta <- matrix(
c(  3.49918412    ,2.18238296   ,39.90512505,
    5.33981703    ,2.33353916   ,45.05829287,
    3.79332030    ,2.32359995   ,44.02875581,
    1.41458189    ,2.27493510   ,41.41182299,
   -1.34569908    ,2.20876868   ,38.02969954,
   -2.93190469    ,2.18504678   ,36.49544717,
   -2.73825634    ,2.26149999   ,38.51046407,
   -5.07314716    ,2.17579044   ,35.03866061,
   -6.83401153    ,2.11642220   ,32.59139536,
   -8.54429668    ,2.04729799   ,29.93426771,
  -10.23899023    ,1.96558566   ,27.03964078,
  -11.45315819    ,1.92858127   ,25.44125261,
  -12.47943683    ,1.88797296   ,23.91656982,
  -13.21499738    ,1.86982260   ,23.11702715,
  -13.90835818    ,1.85771666   ,22.44215914,
  -14.64745028    ,1.82575394   ,21.34977148,
  -15.09732116    ,1.87710219   ,22.17288461,
  -15.53818684    ,1.89568560   ,22.35696787,
  -15.90760567    ,1.98748182   ,24.10821807,
  -16.10028176    ,2.07886832   ,26.03738052,
  -16.95131117    ,2.09314900   ,25.81376868,
  -17.99404303    ,2.10982134   ,25.49361263,
  -19.18522954    ,2.11958795   ,24.93914031,
  -20.67874485    ,2.10281587   ,23.59447506,
  -22.89088741    ,2.08039665   ,21.66134722),
25,3,byrow=TRUE)

if (k == 34) beta <- matrix(
c( -1.87904205    ,1.95637122   ,31.82535939,
   -3.70587789    ,1.90702557   ,29.84986086,
   -4.25746866    ,1.92384291   ,30.17458168,
   -6.19062822    ,1.84512839   ,27.34527667,
   -7.71598697    ,1.79647353   ,25.37065953,
   -8.66496173    ,1.80334805   ,24.95318041,
   -8.70364868    ,1.86762114   ,26.47381045,
   -9.00287451    ,1.92175111   ,27.54904842,
   -9.24991252    ,1.95980244   ,28.37338777,
   -9.35502622    ,2.01247125   ,29.57937538,
  -10.02096400    ,2.01932429   ,29.35842920,
  -10.24389309    ,2.09012034   ,30.84581849,
  -10.95490336    ,2.08669235   ,30.37324510,
  -12.39766290    ,2.02540541   ,28.04703903,
  -12.89738572    ,2.05197978   ,28.35502035,
  -14.44427022    ,1.98364086   ,25.75756328,
  -15.66013378    ,1.90769049   ,23.29418855,
  -16.00471836    ,1.97192964   ,24.51496213,
  -16.75949595    ,1.97792112   ,24.19213119,
  -17.81437945    ,1.94519664   ,22.77041004,
  -18.63545853    ,1.95995856   ,22.57927514,
  -19.57746736    ,1.92788693   ,21.30629347,
  -20.60558568    ,1.93441921   ,20.80122429,
  -21.83169310    ,1.86700483   ,18.60703417,
  -23.53760520    ,1.80405787   ,16.21771016),
25,3,byrow=TRUE)

if (k == 35) beta <- matrix(
c( -1.38741624    ,1.96057226   ,33.29591918,
   -2.37305402    ,1.97649544   ,33.30609342,
   -4.60582479    ,1.89650961   ,30.24042023,
   -3.79436405    ,2.01479215   ,33.75161701,
   -4.65717737    ,2.03764762   ,33.81096354,
   -5.48990453    ,2.04597911   ,33.59249416,
   -6.11551975    ,2.06861081   ,33.82575759,
   -7.09724531    ,2.07120542   ,33.29774247,
   -8.41267080    ,2.04378553   ,31.84313893,
   -8.86764510    ,2.07647472   ,32.36983772,
   -9.77720339    ,2.06469001   ,31.56830670,
  -11.15599848    ,2.01674968   ,29.58058382,
  -11.99682738    ,2.00503687   ,28.80105874,
  -13.03109875    ,1.97704574   ,27.51697672,
  -14.13981077    ,1.92559284   ,25.63488856,
  -15.29127726    ,1.88492752   ,23.95376870,
  -16.07601427    ,1.89150601   ,23.59156224,
  -16.50168827    ,1.95322767   ,24.73432925,
  -17.22186887    ,1.97079344   ,24.70575890,
  -17.84240941    ,2.01260695   ,25.29659713,
  -18.74279061    ,1.98191357   ,24.08482791,
  -19.90527390    ,1.91382985   ,21.82461724,
  -20.85777024    ,1.86674203   ,20.23435131,
  -22.09373421    ,1.83954008   ,18.86918337,
  -23.97211012    ,1.80295368   ,16.86181653),
25,3,byrow=TRUE)

if (k == 36) beta <- matrix(
c(  4.04157768    ,2.20548722   ,44.21603393,
    0.04182197    ,2.08373196   ,38.79814299,
    0.61384346    ,2.16081883   ,41.46568178,
   -0.72639998    ,2.15261220   ,40.57574490,
   -2.22719318    ,2.13316290   ,39.24300379,
   -3.36486521    ,2.13438108   ,38.62014886,
   -4.34975602    ,2.14274784   ,38.24654076,
   -5.35606244    ,2.14488561   ,37.70244534,
   -6.06677032    ,2.16618468   ,37.83927778,
   -7.77809480    ,2.13409385   ,35.85396602,
   -8.05448839    ,2.18941072   ,37.07005599,
   -8.23545215    ,2.24717594   ,38.45867575,
   -9.39726312    ,2.22726740   ,37.22688035,
  -10.59968515    ,2.21523922   ,36.13681955,
  -11.91120641    ,2.17606562   ,34.32398040,
  -13.19096336    ,2.14523204   ,32.74187691,
  -14.41262704    ,2.11094264   ,31.11656016,
  -16.04750912    ,2.00762014   ,27.57273246,
  -17.14497915    ,1.97948472   ,26.19711022,
  -18.09036888    ,1.96182722   ,25.18177188,
  -19.40587352    ,1.88602828   ,22.53988100,
  -20.29073981    ,1.89945866   ,22.30562166,
  -21.41614499    ,1.94042039   ,22.50219467,
  -22.82899068    ,1.87606166   ,20.13698844,
  -24.66955951    ,1.79537809   ,17.14090448),
25,3,byrow=TRUE)

if (k == 37) beta <- matrix(
c( -1.95276701    ,1.91342851   ,33.92656713,
    0.64442615    ,2.09570797   ,40.69978339,
    0.28727257    ,2.13619818   ,41.80584778,
    0.02767817    ,2.17844220   ,42.97891027,
   -3.73322123    ,2.03687209   ,36.96603292,
   -4.37373035    ,2.06443573   ,37.36793388,
   -6.00184118    ,2.02357164   ,35.36845208,
   -6.85014217    ,2.05173221   ,35.51530910,
   -8.23537131    ,2.02762730   ,34.04146182,
   -8.95329112    ,2.04219492   ,33.97083008,
  -10.18488869    ,2.03059090   ,32.86264710,
  -10.96892597    ,2.04780194   ,32.81195849,
  -11.23269253    ,2.09640691   ,33.90392101,
  -11.67289685    ,2.13130985   ,34.56505936,
  -12.86617676    ,2.09827117   ,32.97591948,
  -14.34494230    ,2.05168284   ,30.82829904,
  -15.48767618    ,2.03757533   ,29.70223590,
  -16.03045910    ,2.06754063   ,30.11935378,
  -17.46123357    ,2.00512551   ,27.64578509,
  -18.21522262    ,2.03302941   ,27.84059951,
  -19.31829837    ,2.03215289   ,27.07967397,
  -20.12427047    ,2.10317545   ,28.28600413,
  -21.26976120    ,2.13066721   ,28.21982531,
  -23.05961241    ,2.10363648   ,26.36549518,
  -25.62150554    ,2.01090827   ,22.41389926),
25,3,byrow=TRUE)

if (k == 38) beta <- matrix(
c( -0.78810468    ,1.96640331   ,37.06849436,
   -2.19389888    ,1.96466281   ,36.41201746,
   -3.25108912    ,1.96597088   ,36.03565867,
   -4.36592616    ,1.97226988   ,35.63181039,
   -6.04444193    ,1.95211500   ,34.06569345,
   -5.60451921    ,2.06260093   ,37.25172975,
   -7.13409115    ,2.03060633   ,35.50227142,
   -7.39586482    ,2.08234938   ,36.73996460,
  -10.08138793    ,1.95731095   ,31.82821957,
  -11.16978920    ,1.94094549   ,30.73351779,
  -11.28037035    ,2.00192140   ,32.26836741,
  -12.46833927    ,1.97608595   ,30.88129669,
  -13.43383146    ,1.94254205   ,29.48857036,
  -14.64869429    ,1.93619566   ,28.46758703,
  -15.20887219    ,1.95853451   ,28.69140828,
  -14.97789724    ,2.07287375   ,31.78221623,
  -15.71231685    ,2.08837541   ,31.70359431,
  -16.58010722    ,2.09359646   ,31.26545442,
  -17.49225486    ,2.13451161   ,31.64928266,
  -18.78235158    ,2.13392649   ,30.71897143,
  -19.72688755    ,2.12610472   ,29.96019601,
  -21.33516895    ,2.06208516   ,27.27237503,
  -22.49287153    ,2.11631280   ,27.84745068,
  -24.30142779    ,2.06681278   ,25.43005149,
  -26.49912014    ,1.90590346   ,20.14300842),
25,3,byrow=TRUE)

if (k == 39) beta <- matrix(
c(  6.01842898    ,2.25492313   ,50.36120334,
    6.03408774    ,2.31885226   ,52.56760837,
    3.79440345    ,2.29179041   ,50.57647864,
    6.09813898    ,2.44399801   ,56.68147362,
    1.72335035    ,2.32255178   ,50.43194435,
    0.72215896    ,2.33632581   ,50.27468663,
    0.40812267    ,2.38354198   ,51.47110435,
   -1.65936900    ,2.34945643   ,49.16346034,
   -4.81397025    ,2.26600141   ,44.69900888,
   -6.33160588    ,2.25515667   ,43.35319229,
   -7.86987794    ,2.24071420   ,41.90284650,
   -9.83736506    ,2.19650732   ,39.36892212,
  -11.39174407    ,2.16452496   ,37.45857347,
  -13.13255791    ,2.11233803   ,34.91677832,
  -13.54467212    ,2.15441665   ,35.78307070,
  -13.51363664    ,2.24372318   ,38.22662915,
  -14.15611162    ,2.28100396   ,38.80718430,
  -16.05292604    ,2.20501871   ,35.50480782,
  -17.55611297    ,2.17521401   ,33.69587622,
  -18.67236028    ,2.15743224   ,32.52104008,
  -20.33389032    ,2.11382431   ,30.21509511,
  -21.62369630    ,2.11185721   ,29.31144567,
  -23.03259880    ,2.09433544   ,27.94356093,
  -24.68929107    ,2.08619265   ,26.66940550,
  -27.15682836    ,1.97789861   ,22.35621090),
25,3,byrow=TRUE)

if (k == 40) beta <- matrix(
c(  0.59306793    ,2.03418677   ,41.73932758,
   -1.35356971    ,1.99509998   ,39.83587399,
    1.91157779    ,2.19859125   ,48.00936055,
    1.13097797    ,2.21793341   ,48.29100165,
    1.73061324    ,2.30821056   ,51.42852512,
   -2.35507780    ,2.19339511   ,45.44466115,
   -3.54386908    ,2.21032276   ,45.12462852,
   -5.06961735    ,2.19819669   ,43.79924560,
   -7.49111671    ,2.13187680   ,40.36788466,
   -9.16686900    ,2.08908101   ,38.11820554,
  -11.10456894    ,2.03341913   ,35.31053606,
  -12.77939871    ,1.98581284   ,32.93280310,
  -14.44406034    ,1.92489177   ,30.20146789,
  -14.89361661    ,1.98894940   ,31.57679627,
  -16.07840770    ,1.94954854   ,29.79256050,
  -16.88902965    ,1.95548859   ,29.46725472,
  -17.95000808    ,1.93164548   ,28.16372811,
  -18.64175350    ,1.93184767   ,27.78158751,
  -19.10342899    ,1.99063741   ,29.06637797,
  -20.18316788    ,1.98959811   ,28.30820708,
  -21.48381198    ,1.93189958   ,25.96148743,
  -22.59147178    ,1.94679885   ,25.60649553,
  -23.95778681    ,1.96508451   ,25.13452455,
  -25.52070886    ,1.94966907   ,23.71425256,
  -27.28806432    ,1.83861222   ,19.90271749),
25,3,byrow=TRUE)
beta
}

#********************************************************************#

pv_exp <- function(tn,k,l){
if (l<1) tau <- l else tau <- 1/(1+sqrt(l))
m <- 2
if (k==1) m=4
if (k==2) m=3
if (k==3) m=3
beta <- exp_beta(k)
x <- beta[,(1:m)]%*%as.matrix((tn^c(0:(m-1))))
x <- x*(x>0)
pp <- 1-pchisq(x,beta[,m+1])
taua <- (.5-tau+.01)*50
tau1 <- floor(taua)
p <- (tau1+1-taua)*pp[tau1] + (taua-tau1)*pp[tau1+1]
if (tau == .5) p <- 1-pchisq(tn,k)
if (tau <= .01) p <- pp[25]
if (tau >= .49) p <- ((.5-tau)*pp[1] + (tau-.49)*(1-pchisq(tn,k)))*100
p
}


