%%%%%%%%%%%
% BREAKS.M

% Bruce E. Hansen
% Department of Economics
% Social Science Building
% University of Wisconsin
% Madison, WI 53706-1393
% bhansen@ssc.wisc.edu
% http://www.ssc.wisc.edu/~bhansen/

% Replicates empirical work from
% "The New Econometrics of Structural Change:
% Dating Breaks in U.S. Labor Productivity" 
% by Bruce E. Hansen
%%%%%%%
function breaks()
seas_=12;				% seasonal frequency of data	@
k=1;				    % AR order 		@
trim_=.03;				% trim % for estimation 	@
trimsup_=.05;			% trim % for sup test		@
trimexp_=.05;			% trim % for exp test		@
bootw_=0;			    % # of fixed-regressor bootstrap replications (set to 0 if not desired) @
conf_=.9;				% Confidence Level 		@

out=fopen('ipout.txt','wt');
tit_='Labor Productivity -';

indx=1;
load ip.txt;dat1=ip;
load workers.txt;dat2=workers;
load hours.txt;dat3=hours;

dat=log(dat1)-log(dat2)-log(dat3);
sel=isnan(dat(:,indx));
ind=0;
for i=1:length(sel)
    if sel(i)==0
        if ind==0
            temp=dat(i,indx);
            ind=1;
        else
            temp=[temp;dat(i,indx)];
        end;
    end;
end;
dat=temp;
dat=(dat(2:length(dat))-dat(1:length(dat)-1))*seas_*100;
year_1=1947+1/12;
year_2=year_1-1/12+length(dat)/seas_;

sample_1=year_1;
sample_2=year_2;

tr1=seas_*(sample_1-year_1);
tr2=seas_*(year_2-sample_2);
dy=dat(1+tr1:length(dat)-tr2);
n=length(dy(:,1));
year1=sample_1+1/seas_:1/seas_:(n-1)/seas_+sample_1+1/seas_;

tit2_=['Durables';
    '---SIC24';
    '---SIC25';
    '---SIC32';
    '---SIC33';
    '---SIC34';
    '---SIC35';
    '---SIC36';
    '---SIC37';
    '---SIC38';
    '---SIC39'];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
title_=strcat(tit_,tit2_(indx,:));
plot(year1,dy);
title(title_);
ylabel('Percentage Change - Annual Rate');
grid on;
saveas(gcf,'PeChange.eps','psc2');
% Constant Parameter Model %
yy=dy(k+1:n);
year1=year1(k+1:n);
t=n-k;
tr=(1:t)';
ot=ones(t,1);
xar=x_ar(dy,k);
x=[xar,ot];
rho=(yy'/x')';
e0=yy-x*rho;
ee0=e0'*e0;
sig=ee0/(t-k-1);
xx=inv(x'*x);
v=xx*(x.*(e0*ones(1,length(x(1,:)))))'*(x.*(e0*ones(1,length(x(1,:)))))*xx;
se=sqrt(diag(v));

names_=strcat('DY(-',num2str(1),')__');
for i=2:k
    names_=[names_;strcat('DY(-',num2str(i),')__')];
end;
names_=[names_;'C_______'];
fprintf(out,'%s\n',title_);
fprintf(out,'Sample for years %u   %u\n',sample_1,sample_2);
fprintf(out,'Number of AR Lags: %u\n\n',k);
fprintf(out,'Constant Parameter AR Model\n');
fprintf(out,'Variable   Estimate   St Error\n');
fprintf(out,'------------------------------\n');
for i=1:length(se(:,1))
    fprintf(out,'%s     %f   %f\n',names_(i,:),rho(i),se(i));
end;
fprintf(out,'Sigma   %f\n',sqrt(sig));
fprintf(out,'******************************\n\n');

% Structural Change Model %

[kest,ss]=splitest(yy,x,0,trim_);
d=(tr<=kest);
ind=0;
for i=1:length(d)
    if d(i)==1
        if ind==0
            y1=yy(i,:);
            x1=x(i,:);
            ind=1;
        else
            y1=[y1;yy(i,:)];
            x1=[x1;x(i,:)];
        end;
    end;
end;
t1=length(y1(:,1));
d=1-d;
ind=0;
for i=1:length(d)
    if d(i)==1
        if ind==0
            y2=yy(i,:);
            x2=x(i,:);
            ind=1;
        else
            y2=[y2;yy(i,:)];
            x2=[x2;x(i,:)];
        end;
    end;
end;
t2=length(y2(:,1));

% Regime 1 Estimates %
rho1=(y1'/x1')';
e1=y1-x1*rho1;
ee1=e1'*e1;
sig1=ee1/(t1-k-1);
q1=x1'*x1;
xx=inv(q1);
q1=(q1'/t1')';
v1=xx*(x1.*(e1*ones(1,length(x1(1,:)))))'*(x1.*(e1*ones(1,length(x1(1,:)))))*xx;
se1=sqrt(diag(v1));
sumrho=1-sum(rho1(1:k));
mu1=rho1(k+1)/sumrho;
h1=([(ones(k,1)*mu1);1])/sumrho;
vmu1=h1'*v1*h1;

% Regime 2 Estimates %
    
rho2=(y2'/x2')';
e2=y2-x2*rho2;
ee2=e2'*e2;
sig2=ee2/(t2-k-1);
q2=x2'*x2;
xx=inv(q2);
q2=(q2'/t2')';
v2=xx*(x2.*(e2*ones(1,length(x2(1,:)))))'*(x2.*(e2*ones(1,length(x2(1,:)))))*xx;
se2=sqrt(diag(v2));
mu2=rho2(k+1)/sumrho;
h2=([(ones(k,1)*mu2);1])/sumrho;
vmu2=h2'*v2*h2;

tm=(mu2-mu1)/sqrt(vmu1+vmu2);
e=[e1;e2];

% Confidence Interval for Breakdate %
delta=rho2-rho1;
xsi=((delta'*q2*delta)'/(delta'*q1*delta)')';
phi=xsi*sig2/sig1;
[c1,c2]=bai_qnt(xsi,phi,1-conf_);
ll=(delta'*q1*delta)/sig1;
k1=kest-1-ceil(c2/ll);
k2=kest+1-floor(c1/ll);
k1=max([k1;1]);
k2=min([k2;t]);

% Graph SSE %
ss=ss/t;
plot(year1,ss);
grid on;
ylabel('Residual Variance');
xlabel('Breakdate');
title('Least Squares Breakdate Estimation: Residual Variance as a Function of Breakdate');

fprintf(out,'Complete Structural Change AR Model\n\n');
fprintf(out,'Estimated Breakdate %f\n',year1(kest));
fprintf(out,'Confidence Interval %f  %f\n',year1(k1),year1(k2));
fprintf(out,'Confidence %f\n',conf_/100);
fprintf(out,'Trimming Percentage %f\n',trim_);
fprintf(out,'t test for equality of means %f\n\n',tm);

fprintf(out,'Regime 1\n');
fprintf(out,'Mean %f   %f\n',mu1,sqrt(vmu1));
fprintf(out,'Variable   Estimate   St Error\n');
fprintf(out,'------------------------------\n');
for i=1:length(se1(:,1))
    fprintf(out,'%s     %f   %f\n',names_(i,:),rho1(i),se1(i));
end;
fprintf(out,'Sigma   %f\n\n',sqrt(sig1));

fprintf(out,'Regime 2\n');
fprintf(out,'Mean %f   %f\n',mu2,sqrt(vmu2));
fprintf(out,'Variable   Estimate   St Error\n');
fprintf(out,'------------------------------\n');
for i=1:length(se2(:,1))
    fprintf(out,'%s     %f   %f\n',names_(i,:),rho2(i),se2(i));
end;
fprintf(out,'Sigma   %f\n\n',sqrt(sig2));
fprintf(out,'******************************\n\n');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Testing for Structural Change %
% Compute W Statistics %
[f,supf,expf,kest]=supw_(yy,x,trimsup_,trimexp_);

% Graph F Statistics %
cv=[[(zeros(k+1,1)+qa_crit(1,trimsup_));qa_crit(k+1,trimsup_)],[(zeros(k+1,1)+chi_crit(1));chi_crit(k+1)]];
name2_=[names_;'Joint___'];
j=1;
while j<=k
    tit=strcat('Testing for Structural Change ',title_,' Intercept');
    z0=ones(t,1)*cv(j,:);
    plot(year1,f(:,j),year1,z0(:,1),year1,z0(:,2));
    grid on;
    title(tit);
    xlabel('Breakdate');
    ylabel('Chow Test');
    legend('Chow Test Sequence','Andrews Critical Value','Chi-Square Critical Value');
    saveas(gcf,strcat('testforSC',num2str(j),'.eps'),'psc2');
    j=j+1;
end;
tit='Testing for Structural Change of Unknown Timing: Chow Test Sequence as a Function of Breakdate';
z0=ones(t,1)*cv(k+1,:);
plot(year1,f(:,k+1),year1,z0(:,1),year1,z0(:,2));
xlabel('Breakdate');
ylabel('Chow Test');
legend('Chow Test Sequence','Andrews Critical Value','Chi-Square Critical Value');
title(tit);
grid on;
saveas(gcf,strcat('testforSC',num2str(k+1),'.eps'),'psc2');


tit='Testing for Structural Change of Unknown Timing: Chow Test Sequence as a Function of Breakdate';
plot(year1,f(:,k+2),year1,z0(:,1),year1,z0(:,2));
xlabel('Breakdate');
ylabel('Chow Test');
legend('Chow Test Sequence','Andrews Critical Value','Chi-Square Critical Value');
ylim([0,24]);
xlim([1950,2000]);
title(tit);
grid on;
saveas(gcf,strcat('testforSC',num2str(k+2),'.eps'),'psc2');

% Andrews' P-Values %
pvs1=zeros(k+2,1);
pve1=zeros(k+2,1);
j=1;
while j<=k+1
    pvs1(j)=pv_sup(supf(j),1,trimsup_);
    pve1(j)=pv_exp(expf(j),1,trimexp_);
    j=j+1;
end;
pvs1(k+2)=pv_sup(supf(k+1),k+1,trimsup_);
pve1(k+2)=pv_exp(expf(k+2),k+1,trimexp_);

fprintf(out,'Test Breakdates\n\n');
fprintf(out,'Variable   BreakEst\n\n');
for i=1:length(kest)
     fprintf(out,'%s   %f\n',name2_(i,:),year1(kest(i)));
end;
fprintf(out,'\n\nTrimming Percentage for SupW: %f',trimsup_);
fprintf(out,'Trimming Percentage for ExpW: %f\n\n',trimexp_);

if bootw_>0
    fprintf(out,'Number of Fixed Regressor Bootstrap Replications\n');
    % Fixed Regressor Bootstrap %
    boots=zeros(bootw_,k+2);
    boote=zeros(bootw_,k+2);
    b=1;
    while b<=bootw_
        yb=e.*normrnd(0,1,t,1);
        [fb,supfb,expfb,kb]=supw_(yb,x,trimsup_,trimexp_);
        boots(b,:)=supfb';
        boote(b,:)=expfb';
        b=b+1;
    end;
    pvs2=mean(boots>(ones(length(boots(:,1)),1)*supf))';
    pve2=mean(boote>(ones(length(boots(:,1)),1)*expf))';
end;

% Print Test Results %
fprintf(out,'SupW Tests on Regression Parameters\n\n');
if bootw_<=0
    fprintf(out,'Variable   supf     Asyp\n');
    for i=1:length(supf)
         fprintf(out,'%s   %f   %f\n',name2_(i,:),supf(i),pvs1(i));
    end;
    fprintf(out,'\n\nVariable   ExpW     Asyp\n');
    for i=1:length(expf)
         fprintf(out,'%s   %f   %f\n',name2_(i,:),expf(i),pve1(i));
    end;
else
    fprintf(out,'Variable   supf     Asyp     FixRegP\n');
    for i=1:length(supf)
        fprintf(out,'%s   %f   %f   %f\n',name2_(i,:),supf(i),pvs1(i),pvs2(i));
    end;
    fprintf(out,'\n\nVariable   supf     Asyp     FixRegP\n');
    for i=1:length(expf)
        fprintf(out,'%s   %f   %f   %f\n',name2_(i,:),expf(i),pve1(i),pve2(i));
    end;
end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Variance Equation  - LS Residuals
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
e2=e0.*e0;
[kest,ss]=splitest(e2,ot,0,trim_);
d=(tr<=kest);
xx=[d,(1-d)];
sigs=(e2'/xx')';
u=e2-xx*sigs;
u1=u(1:kest);
u2=u(kest+1:t);
t1=kest;
t2=t-kest;
sig1=(u1'*u1)/(t1-k-1);
sig2=(u2'*u2)/(t2-k-1);
[c1,c2]=bai_qnt(1,1,1-conf_);
ll=sig1/((sigs(1)-sigs(2))^2);
k1=kest-1-ceil(c2*ll);
k2=kest+1-floor(c1*ll);
k1=max([k1;1]);
k2=min([k2;t]);

fprintf(out,'********************************************\n\n\n');
fprintf(out,'Break in Error Variance\n');
fprintf(out,'Estimated Breakdate: %f\n',year1(kest));
fprintf(out,'Confidence Interval: %f   %f\n',year1(k1),year1(k2));
fprintf(out,'Confidence: %f\n',conf_/100);
fprintf(out,'Regime 1 SD: %f\n',sqrt(sigs(1)));
fprintf(out,'Regime 2 SD: %f\n\n\n',sqrt(sigs(2)));
fprintf(out,'********************************************\n\n\n');

% Graph SSE %
tit=strcat(title_,' Estimation of Breakdate in Variance');
title(tit);
ss=ss/t;
plot(year1,ss);
grid on;
ylabel('Residual Variance');
xlabel('Breakdate');
title(tit);
saveas(gcf,strcat('sse.eps'),'psc2');

% Test Constancy of Variance %

[f,supf,expf,kest]=supw_(e2,ot,trimsup_,trimexp_);
supf=supf(1);expf=expf(1);kest=kest(1);
tests=[supf;expf];
pvvar=[pv_sup(supf,1,trimsup_);pv_exp(expf,1,trimexp_)];
cvvar=qa_crit(1,trimsup_);
fprintf(out,'Tests for Constancy of Error Variance\n\n\n');
fprintf(out,'        Stat     Asyp\n');
fprintf(out,'SupF    %f     %f\n',tests(1),pvvar(1));
fprintf(out,'ExpF    %f     %f\n',tests(2),pvvar(2));

% Graph F Statistics %
tit=strcat(title_,'Wald Sequence for Variance');
z0=ones(t,1)*cvvar;
plot(year1,f(:,1),year1,z0);
grid on;
ylabel('Residual Variance');
xlabel('Breakdate');
legend('Wald Sequence','Asymptotic Critical Value');
saveas(gcf,'Fstat.eps','psc2');
fclose(out);

%**************************************************%
%**************************************************%
%**************************************************%












%%%%%%% 
% ST_CHANG.M 
% procs for structural change analysis
%%%%%%%
function [kest,ss]=splitest(y,x,s,trim_)
t=length(y(:,1));
t1=round(t*trim_);
t2=round(t*(1-trim_));
e=y-x*((y'/x')');
tr=(1:t)';
ss=zeros(t,1)+e'*e;
if s==0
    xs=x;
else
    xs=x(:,s);
end;
i=t1;
while i<=t2
    d=(tr>i);
    z=xs.*(d*ones(1,length(xs(1,:))));
    z=z-x*((z'/x')');
    u=e-z*((e'/z')');
    ss(i)=u'*u;
    i=i+1;
end;
[temp,kest]=min(ss);
clear temp;

function [fsup,supf,expf,kest]=supw_(y,x,trimsup_,trimexp_);
t=length(y(:,1));
kk=length(x(1,:));
f=zeros(t,kk+1);
trim_=min([trimsup_;trimexp_]);
tr=(1:t)';
t1=round(t*trim_);
t2=round(t*(1-trim_));
e=y-x*((y'/x')');
i=t1;
while i<=t2
    d=(tr>i);
    j=1;
    while j<=kk;
        z=x(:,j).*d;
        z=z-x*((z'/x')');
        ze=z'*e;
        beta=(ze'/(z'*z)')';
        v=(z.*(e-z*beta))'*(z.*(e-z*beta));
        f(i,j)=(ze'/v')*ze;
        j=j+1;
    end;
    z=x.*(d*ones(1,length(x(1,:))));
    z=z-x*((z'/x')');
    ze=z'*e;
    beta=(ze'/(z'*z)')';
    v=(z.*((e-z*beta)*ones(1,length(x(1,:)))))'*(z.*((e-z*beta)*ones(1,length(x(1,:)))));
    f(i,kk+1)=(ze'/v')*ze;
    i=i+1;
end;
t1=round(t*trim_);
t2=round(t*(1-trim_));
fsup=zeros(t,kk+1);
fsup(t1:t2,:)=f(t1:t2,:);
[supf,kest]=max(fsup);
expf=log(mean(exp(f(round(t*trimexp_):round(t*(1-trimexp_)),:)/2)));

function [c1,c2]=bai_qnt(xsi,phi,alpha); 
xp=(xsi'/phi')';
a=xp*(1+xp)/2;
b=1/2+xp;
c=phi*(phi+2*xsi)/(phi+xsi)/xsi;
d=((phi+2*xsi)^2)/xsi/(phi+xsi);
x1=(-50:.01:(4999*(.01)-50))';
x2=(.01:.01:50)';
g1=-sqrt(-x1/(2*pi)).*exp(x1/8)-c.*exp(-x1*a).*normcdf(-b.*sqrt(-x1))+(d-2-x1/2).*normcdf(-sqrt(-x1)/2);
a=(phi+xsi)/2;
b=(2*phi+xsi)/2/sqrt(phi);
c=xsi*(2*phi+xsi)/phi/(phi+xsi);
d=((2*phi+xsi)^2)/phi/(phi+xsi);
g2=1+xsi.*sqrt(x2/(2*pi*phi)).*exp(-x2*xsi*xsi/8/phi)+c*exp(x2*a).*normcdf(-sqrt(x2)*b)+(-d+2-x2*xsi*xsi/2/phi).*normcdf(-sqrt(x2/phi)*xsi/2);
x=[x1;x2];
g=[g1;g2];
[temp,m1]=max(g>(alpha/2));
[temp,m2]=max(g>(1-alpha/2));
c1=x(m1);
c2=x(m2);

function crit=qa_crit(k,trim_);
crits=[8.45	8.85	9.31	9.84
11.26	11.79	12.27	12.93
13.69	14.15	14.62	15.15
15.84	16.45	16.98	17.56
17.88	18.35	18.93	19.61
19.64	20.26	20.82	21.56
21.07	21.84	22.51	23.22
21.47	22.13	22.87	23.6
24.91	25.47	26.16	26.94
26.42	27.03	27.87	28.63
27.93	28.55	29.21	30.15
29.61	30.16	30.88	31.76
31.1	31.8	32.62	33.42
32.65	33.45	34.22	35
34.41	35.06	35.76	36.74
35.95	36.66	37.48	38.51
37.49	38.12	39.05	40.05
38.77	39.55	40.38	41.36
40.43	41.25	42.01	43.05
41.9	43	43.76	44.52];
if trim_==.2
    crit=crits(k,1);
elseif trim_==.15
    crit=crits(k,2);
elseif trim_==.10
    crit=crits(k,3);
elseif trim_==.05
    crit=crits(k,4);
else
    crit=NaN;
end;

function crit=ap_crit(k,trim_);
crits=[2.06	2.08	2.08	2.08
3.22	3.25	3.27	3.3
4.22	4.28	4.3	4.3
5.23	5.24	5.3	5.34
6.13	6.17	6.22	6.25
6.92	9.98	7.09	7.12
7.66	7.77	7.85	7.95
8.6	8.68	8.79	8.86
9.35	9.42	9.55	9.63
10.04	10.19	10.34	10.43
10.75	10.88	11.01	11.12
11.55	11.65	11.78	11.86
12.28	12.49	12.55	12.84
13.09	13.2	13.31	13.59
13.84	10.01	14.16	14.28
14.63	14.8	14.96	15.13
15.3	15.52	15.7	15.87
15.93	16.12	16.3	16.46
16.73	16.89	17.1	17.21
17.57	17.73	17.92	18];
if trim_==.15
    crit=crits(k,1);
elseif trim_==.10
    crit=crits(k,2);
elseif trim_==.05
    crit=crits(k,3);
elseif trim_==.02
    crit=ctits(k,4);
else
    crit=NaN;
end;

function crit=chi_crit(k);
crits=[3.84 5.99 7.81 9.49 11.07 12.59 14.07 15.51 16.92 18.31 19.68 21.03 22.36 23.68 25 26.3 27.59 28.87 30.14 31.41];
crit=crits(k);


function r=x_ar(y,k)
oy=ones(k,1)*y';
oy=oy';
t=length(y);
for i=1:k
    temp=oy(:,i);
    for j=1:i
        temp=[NaN;temp];
    end;    
    oy(:,i)=temp(1:t);
end;
if length(oy(1,:))>1
    tt=isnan(sum(oy')');
else
    tt=isnan(oy);
end;


ind=0;
for i=1:t
    if tt(i)==0
        if ind==0
            temp=oy(i,:);
            ind=1;
        else
            temp=[temp;oy(i,:)];
        end;
    end;
end;
r=temp;
