#########################################################################
##  MAIN.R
##  
##  Bruce E. Hansen
##  Department of Economics
##  Social Science Building
##  University of Wisconsin
##  Madison, WI 53706-1393
##  behansen@wisc.edu
##  http://www.ssc.wisc.edu/~bhansen/
##  
##  This is a R program.
##  It will compute fully modified estimators of cointegrating relationships
##  and test for stability of such relationships.
##  This program calls a procedure which is in the file fm.r.
##  The covariance parameters are calculated with the Quadratic Spectral kernel
##  
##  The procedure fm.R takes the form
##  
##        out <- fm(y,x,k1,k2)
##  
##  where
##     y  =  Dependent variable
##     x  =  Right Hand Side I(1) variables
##     k1 =  A non-negative integer.  It is the highest integer power of time
##           to be included in the regression equation.  For example, k1 = 0
##           means that a constant will be included.  k1 = 1 means that a
##           constant and a time trend will be included.
##  
##     k2 =  A non-negative integer.  It is the highest integer power of time
##           which is believed to be describing the stochastic process of the
##           regressors  x.  For example, if x is believed to be I(1) plus
##           drift (differences of x have non-zero mean), then set k2 = 1.
##           If x is believed to be I(1) plus a quadratic trend, then set
##           k2 = 2.
##
##  There are six output items passed back from the procedure:
##  
##  b1    = Fully modified estimates of the coefficients on the regressors  x .
##  b2    = Fully modified estimates of the coefficients on the trend regressors.
##          These are order as follows:  constant, trend, quadratic ...
##  v     = Fully modified covariance matrix for the vector (b1 b2).
##  u     = Fully modified residuals.
##  f     = Sequence of F-tests for model stability
##  tests = Lc, SupF, and MeanF  (in that order)           
##  
##  Example :  Empirical work in Hansen (1991) "Tests for parameter instability
##             in regressions with I(1) processes."            
##
#########################################################################

# The following global variables may be set #           
    
  whiten <- 0      # Set at 0, covariances calculated by first pre-whitening
                   # using a VAR(1).
                   # Set at 1, pre-whitening not done 
  
  kernel <- 1      # Set at 1  -  Quadratic Spectral kernel is used
                   # Set at 2  -  Parzen kernel is used
                   # Set at 3  -  Bartlett kernel is used      
  
  band  <- 0       # Set at 0, covariances calculated using Andrews (1991)
                   # automatic bandwidth.  The weight matrix W is the
                   # identity matrix.  A VAR(1) model is used to calculate
                   # the automatic bandwidth.
                   # Set at a positive number, the bandwidth is set to
                   # this number.   
  
  poutput <- 0     # Set at 0, output is printed
                   # Set at 1, output is not printed 
  
  test <- 0        # Set at 0, test statistics are calculated
                   # Set at 1, test statistics are not calculated
  
  fplot <- 1       # Set at 1, plot of sequential F-tests will be done

               
#*********************************************************************#

source ("fm.R")   

campbell <- as.matrix(read.table("campbell.dat"))  
di <- as.matrix(campbell[,1])
tc <- as.matrix(campbell[,3])
nds <- as.matrix(campbell[,4])
rates <- as.matrix(read.table("rates.dat"))
ff <- as.matrix(rates[,1])
short <- as.matrix(rates[,2])
long <- as.matrix(rates[,3])
stock <- as.matrix(read.table("stock.dat"))
price <- as.matrix(stock[,1])
div <- as.matrix(stock[,2])

for (fmp in 1:1){
cat ("Total Consumption upon Disposable Income, Linear ","\n")
cat ("\n")
out <- fm(tc,di,1,1)
cat ("\n")
cat ("\n")
if (fplot == 1){
 x11()
 mtit <- "Total Consumption, 1953:1984"
 xtit <- "Figure 1"
 ytit <- "F stat"
 t <- nrow(tc)
 firstob <- 1954.5 + round(.15*t)/4
 inc  <- .25
 rf <- nrow(out$f)
 crit <- matrix(1,rf,1)%*%cbind(15.2,6.22,7.815)
 ytics <- range(cbind(out$f,crit))
 xx <- as.matrix(seq(firstob,firstob+(rf-1)*inc,inc))
 plot(xx,out$f,type="l",ylim=ytics,lty=1,col=1,ann=0)  
 lines(xx,crit[,1],lty=2,col=2)
 lines(xx,crit[,2],lty=3,col=3)
 lines(xx,crit[,3],lty=4,col=4)
 title(main=mtit,ylab=ytit,xlab=xtit) 
 legend("topright",c("F Statistic Sequence","5% Critical, SupF",
 "5% Critical, MeanF","5% Critical, Known Break"),lty=c(1,2,3,4),col=c(1,2,3,4))
}

cat ("NDS Consumption upon Disposable Income, Linear ","\n")
cat ("\n")
out <- fm(nds,di,1,1)
cat ("\n")
cat ("\n")
if (fplot == 1){
 x11()
 mtit <- "NDS Consumption, 1953:1984"
 xtit <- "Figure 2"
 ytit <- "F stat"
 t <- nrow(tc)
 firstob <- 1954.5 + round(.15*t)/4
 inc  <- .25
 rf <- nrow(out$f)
 crit <- matrix(1,rf,1)%*%cbind(15.2,6.22,7.815)
 ytics <- range(cbind(out$f,crit))
 xx <- as.matrix(seq(firstob,firstob+(rf-1)*inc,inc))
 plot(xx,out$f,type="l",ylim=ytics,lty=1,col=1,ann=0)  
 lines(xx,crit[,1],lty=2,col=2)
 lines(xx,crit[,2],lty=3,col=3)
 lines(xx,crit[,3],lty=4,col=4)
 title(main=mtit,ylab=ytit,xlab=xtit) 
 legend("topright",c("F Statistic Sequence","5% Critical, SupF",
 "5% Critical, MeanF","5% Critical, Known Break"),lty=c(1,2,3,4),col=c(1,2,3,4))
}

cat ("Stock Prices Upon Dividends, Linear","\n")
cat ("\n")
out <- fm(price,div,0,0)
cat ("\n")
cat ("\n")
if (fplot == 1){
 x11()
 mtit <- "Stock Prices and Dividends, 1871-1986"
 xtit <- "Figure 3"
 ytit <- "F stat"
 t <- nrow(price)
 firstob <- 1872 + round(.15*t)
 inc  <- 1
 rf <- nrow(out$f)
 crit <- matrix(1,rf,1)%*%cbind(12.4,4.57,5.99)
 ytics <- range(cbind(out$f,crit))
 xx <- as.matrix(seq(firstob,firstob+(rf-1)*inc,inc))
 plot(xx,out$f,type="l",ylim=ytics,lty=1,col=1,ann=0)  
 lines(xx,crit[,1],lty=2,col=2)
 lines(xx,crit[,2],lty=3,col=3)
 lines(xx,crit[,3],lty=4,col=4)
 title(main=mtit,ylab=ytit,xlab=xtit) 
 legend("topright",c("F Statistic Sequence","5% Critical, SupF",
 "5% Critical, MeanF","5% Critical, Known Break"),lty=c(1,2,3,4),col=c(1,2,3,4))
}

cat ("Stock Prices Upon Dividends, Logs","\n")
cat ("\n")
out <- fm(log(price),log(div),0,0)
cat ("\n")
cat ("\n")
if (fplot == 1){
 x11()
 mtit <- "Logged Stock Prices and Dividends, 1871-1986"
 xtit <- "Figure 4"
 ytit <- "F stat"
 t <- nrow(price)
 firstob <- 1872 + round(.15*t)
 inc  <- 1
 rf <- nrow(out$f)
 crit <- matrix(1,rf,1)%*%cbind(12.4,4.57,5.99)
 ytics <- range(cbind(out$f,crit))
 xx <- as.matrix(seq(firstob,firstob+(rf-1)*inc,inc))
 plot(xx,out$f,type="l",ylim=ytics,lty=1,col=1,ann=0)  
 lines(xx,crit[,1],lty=2,col=2)
 lines(xx,crit[,2],lty=3,col=3)
 lines(xx,crit[,3],lty=4,col=4)
 title(main=mtit,ylab=ytit,xlab=xtit) 
 legend("topright",c("F Statistic Sequence","5% Critical, SupF",
 "5% Critical, MeanF","5% Critical, Known Break"),lty=c(1,2,3,4),col=c(1,2,3,4))
}

cat ("Short Rates Upon Long Rates,  Nominal","\n")
cat ("\n")
out <- fm(short,long,0,0)
cat ("\n")
cat ("\n")
if (fplot == 1){
 x11()
 mtit <- "3-Month and 1-Year Treasury Bill Rates, 1960-1990"
 xtit <- "Figure 5"
 ytit <- "F stat"
 t <- nrow(short)
 firstob <- 1960 + round(.15*t)/12
 inc  <- 1/12
 rf <- nrow(out$f)
 crit <- matrix(1,rf,1)%*%cbind(12.4,4.57,5.99)
 ytics <- range(cbind(out$f,crit))
 xx <- as.matrix(seq(firstob,firstob+(rf-1)*inc,inc))
 plot(xx,out$f,type="l",ylim=ytics,lty=1,col=1,ann=0)  
 lines(xx,crit[,1],lty=2,col=2)
 lines(xx,crit[,2],lty=3,col=3)
 lines(xx,crit[,3],lty=4,col=4)
 title(main=mtit,ylab=ytit,xlab=xtit) 
 legend("topright",c("F Statistic Sequence","5% Critical, SupF",
 "5% Critical, MeanF","5% Critical, Known Break"),lty=c(1,2,3,4),col=c(1,2,3,4))
}

cat ("Short Rates Upon Federal Funds Rates","\n")
cat ("\n")
out <- fm(short,ff,0,0)
cat ("\n")
cat ("\n")
if (fplot == 1){
 x11()
 mtit <- "3-Month Treasury Bill and Federal Funds Rates, 1960-1990"
 xtit <- "Figure 6"
 ytit <- "F stat"
 t <- nrow(short)
 firstob <- 1960 + round(.15*t)/12
 inc  <- 1/12
 rf <- nrow(out$f)
 crit <- matrix(1,rf,1)%*%cbind(12.4,4.57,5.99)
 ytics <- range(cbind(out$f,crit))
 xx <- as.matrix(seq(firstob,firstob+(rf-1)*inc,inc))
 plot(xx,out$f,type="l",ylim=ytics,lty=1,col=1,ann=0)  
 lines(xx,crit[,1],lty=2,col=2)
 lines(xx,crit[,2],lty=3,col=3)
 lines(xx,crit[,3],lty=4,col=4)
 title(main=mtit,ylab=ytit,xlab=xtit) 
 legend("topright",c("F Statistic Sequence","5% Critical, SupF",
 "5% Critical, MeanF","5% Critical, Known Break"),lty=c(1,2,3,4),col=c(1,2,3,4))
}

cat ("Long Rates Upon Federal Funds Rates","\n")
cat ("\n")
out <- fm(long,ff,0,0)
cat ("\n")
cat ("\n")
if (fplot == 1){
 x11()
 mtit <- "1-Year Treasury Bill and Federal Funds Rates, 1960-1990"
 xtit <- "Figure 6"
 ytit <- "F stat"
 t <- nrow(short)
 firstob <- 1960 + round(.15*t)/12
 inc  <- 1/12
 rf <- nrow(out$f)
 crit <- matrix(1,rf,1)%*%cbind(12.4,4.57,5.99)
 ytics <- range(cbind(out$f,crit))
 xx <- as.matrix(seq(firstob,firstob+(rf-1)*inc,inc))
 plot(xx,out$f,type="l",ylim=ytics,lty=1,col=1,ann=0)  
 lines(xx,crit[,1],lty=2,col=2)
 lines(xx,crit[,2],lty=3,col=3)
 lines(xx,crit[,3],lty=4,col=4)
 title(main=mtit,ylab=ytit,xlab=xtit) 
 legend("topright",c("F Statistic Sequence","5% Critical, SupF",
 "5% Critical, MeanF","5% Critical, Known Break"),lty=c(1,2,3,4),col=c(1,2,3,4))
}
}





