#########################################################################
##  FM.R
##  
##  This is a R program.  It executes the procedure fm(y,x,k1,k2)
##  which is explained in the example file main.R
##
##  Bruce E. Hansen
##  Department of Economics
##  Social Science Building
##  University of Wisconsin
##  Madison, WI 53706-1393
##  behansen@wisc.edu
##  http://www.ssc.wisc.edu/~bhansen/
#3
#########################################################################

fm <- function(y,x,k1,k2){

fmcrit <- matrix(c( 
1.9541680,      -0.37328939,      0.024575262,   -0.00055327331,
1.0800038,      -0.51084717,      0.084311339,    -0.0047798770,
0.92696063,      -3.5355317,        4.7711191,       -2.2245239,
2.4865556,      -0.39952372,      0.021931867,   -0.00040957396,
1.5952133,      -0.61278630,      0.081804512,    -0.0037449886,
1.1202840,       -3.6436527,        4.1553033,       -1.6280553,
1.9604138,      -0.34958720,      0.021313986,   -0.00044199058,
1.0078304,      -0.47045939,      0.077255740,    -0.0043845742,
0.76892894,      -3.4322674,        5.4713896,       -3.0411469,
2.6659636,      -0.42367576,      0.023031842,   -0.00042656099,
1.3855405,      -0.50124110,      0.062944545,    -0.0027129772,
0.99624428,      -3.4929591,        4.3105483,       -1.8340943,
3.4804277,      -0.50535996,      0.025031776,   -0.00042113508,
1.6410089,      -0.47881034,      0.047897512,    -0.0016311073,
1.1706978,       -3.4207804,        3.5068050,       -1.2395319,
3.1821750,      -0.49111312,      0.025771858,   -0.00045780153,
1.4766654,      -0.55666440,      0.072860224,    -0.0032599448,
0.85540501,      -3.8286115,        6.0850783,       -3.3424818,
3.6516493,      -0.51068260,      0.024292212,   -0.00039149699,
1.8184280,      -0.56424493,      0.060675193,    -0.0022348862,
1.0741719,       -3.6581953,        4.3577651,       -1.7779576,
4.0030156,      -0.50787555,      0.021889454,   -0.00031953160,
2.1207950,      -0.55000703,      0.048949379,    -0.0014849560,
1.2632400,       -3.5111909,        3.4037486,       -1.1329408,
2.8816090,      -0.40327754,      0.019278950,   -0.00031407078,
1.4477601,      -0.39749377,      0.037031003,    -0.0011653953,
1.2468682,       -3.3928267,        3.2354818,       -1.0655657,
3.2476994,      -0.39699660,      0.016346409,   -0.00022599401,
2.2209849,      -0.57991932,      0.051982832,    -0.0015882815,
1.4302220,       -3.6226406,        3.1846286,      -0.95908418,
4.4879269,      -0.52308913,      0.020630372,   -0.00027457954,
2.6404388,      -0.60926610,      0.047975889,    -0.0012826061,
1.4963005,       -3.6364920,        3.0747668,      -0.89352493,
3.5219212,      -0.44902542,      0.019392678,   -0.00028297754,
2.1623351,      -0.56425294,      0.050523709,    -0.0015416765,
1.4511468,       -3.5147064,        2.9424961,      -0.84101131,
4.0303937,      -0.47157676,      0.018728733,   -0.00025195014,
2.4396486,      -0.55091334,      0.042636952,    -0.0011260605,
1.6936335,       -3.8351063,        2.9919337,      -0.79520273,
5.3405143,      -0.59430383,      0.022404958,   -0.00028524985,
3.2870762,      -0.70189574,      0.051221375,    -0.0012689016,
1.7263214,       -3.7289379,        2.7922780,      -0.71599348),
14,12,byrow=TRUE)

# Construct Trends #
t <- nrow(y)
t1 <- as.matrix(seq(1,t,1))

# trends in regressors #
indx <- as.matrix(seq(0,max(rbind(1,k2))-1,1))
t2 <- as.matrix(t1[1:(t-1)])%*%matrix(1,1,nrow(indx))
for (j in 1:nrow(indx)) t2[,j] <- as.matrix(t1[1:(t-1)])^indx[j]

# trends in regression #
indx <- as.matrix(seq(0,k1,1))
tt1 <- matrix(0,nrow(t1),nrow(indx))
for (j in 1:nrow(indx)) tt1[,j] <- t1^indx[j]
t1 <- tt1
          
xt <- cbind(x,t1)
y2 <- as.matrix(y[2:t,])
x2 <- xt[2:t,]

# OLS #
xxi <- solve(t(x2)%*%x2) 
xy <- t(x2)%*%y2
b <- xxi%*%xy     # OLS coefficients #
# Construct u2 #
u2 <- as.matrix(x[2:t,] - x[1:(t-1),])
u2 <- u2 - t2%*%qr.solve((t(t2)%*%t2),(t(t2)%*%u2))  # regressor innovation #
xdx <- t(x2)%*%u2
p1 <- ncol(y)
p2 <- ncol(x)
p <- p1 + p2
u <- cbind((y2 - x2%*%b),u2)   #  Residuals  #

# PreWhiten Residuals Using VAR(1)  #
if (whiten == 0){
 ub <- u[1:(t-2),]
 uf <- u[2:(t-1),]
 a <- solve(t(ub)%*%ub)%*%(t(ub)%*%uf)   # VAR(1) matrix #
 e <- uf - ub%*%a   # Whitened residuals #
 te <- t-2
}else{
 e <- u
 te <- t-1
}

# Select Bandwidth #
if (band == 0){
 eb <- e[1:(te-1),]
 ef <- e[2:te,]
 ae <- as.matrix(colSums(eb*ef)/colSums(eb^2))
 ee <- ef - eb*(matrix(1,nrow(eb),1)%*%t(ae))
 se <- as.matrix(sqrt(colMeans(ee^2)))
 ad <- sum((se/((1-ae)^2))^2)
 a1 <- 4*sum((ae*se/(((1-ae)^3)*(1+ae)))^2)/ad
 a2 <- 4*sum((ae*se/((1-ae)^4))^2)/ad
 if (kernel == 1) eband <- 1.3221*((a2*te)^.2)   #  Quadratic Spectral #
 if (kernel == 2) eband <- 2.6614*((a2*te)^.2)   #  Parzen     #
 if (kernel == 3) eband <- 1.1447*((a1*te)^.333) #  Bartlett   #
}else{
 eband <- band
}

# Estimate Covariances #
jb <- as.matrix(seq(1,te-1,1)/eband)
if (kernel == 1){                           # Quadratic Spectral Kernel #
  jband <- jb*1.2*pi
  kern <- ((sin(jband)/jband - cos(jband))/(jband^2))*3
}
if (kernel == 2){                           # Parzen kernel #
  kern <- (1 - (jb^2)*6 + (jb^3)*6)*(jb <= .5)
  kern <- kern + ((1-jb)^3)*(jb <=1)*(jb > .5)*2
}
if (kernel == 3){                           # Bartlett kernel #
  kern <- (1-jb)*(jb <= 1)
}

sig <- t(e)%*%e
lam <- matrix(0,p,p) 
for (j in 1:(te-1)){ 
    if (j < te-1) lam <- lam+(t(e[1:(te-j),])%*%e[(1+j):te,])*kern[j]
    if (j ==te-1) lam <- lam+(as.matrix(e[1:(te-j),])%*%t(as.matrix(e[(1+j):te,])))*kern[j]
}
delta <- sig + lam
omega <- sig + lam + t(lam)
uu <- t(u)%*%u

# Recolor #
if (whiten == 0){
 ai <- solve(diag(p) - a)
 omega <- t(ai)%*%omega%*%ai
 delta <- t(ai)%*%delta%*%ai - t(ai)%*%t(a)%*%uu
}

# Fully Modified Estimation #
g <-  qr.solve(omega[2:p,2:p],omega[2:p,1])
delg <- delta[2:p,1] - delta[2:p,2:p]%*%g
delg <- rbind(delg,matrix(0,k1+1,p1))
ystar <- y2 - u2%*%g

b <- xxi%*%((t(x2)%*%ystar) - delg)
b1 <- as.matrix(b[1:p2])
b2 <- as.matrix(b[(p2+1):nrow(b)])

#  Covariance Matrix #
sg <- as.vector((omega[1,1] - omega[1,2:p]%*%g)/(t-1))
v <- xxi*sg
u <- ystar - x2%*%b
se <- as.matrix(sqrt(diag(v)))

if (test == 0){
#  Stability Test Statistics  #
s <- x2*(u%*%matrix(1,1,ncol(x2)))-matrix(1,nrow(x2),1)%*%(t(delg)/(t-1)) # Scores # 
for (j in 1:ncol(x2)) s[,j] <- cumsum(s[,j]) # Cummulative Scores #

lc <- sum(diag((t(s)%*%s)%*%xxi))/(sg*(t-1)) # LC test #         
t1 <- round(t*.15)                           # Trimming  #            
t2 <- round(t*.85)
f <- matrix(0,(t2-t1+1),1)
for (j in t1:t2){
  sj <- as.matrix(s[j,])                   #  j'th score   #        
  vj <- t(x2[1:j,])%*%x2[1:j,]
  mj <- vj - vj%*%xxi%*%vj
  f[j-t1+1] <- t(sj)%*%solve(mj)%*%sj      #  j'th f-stat  #        
}

f <- f/sg
meanf <- mean(f)                    #  MeanF stat  #         
supf <- max(f)                      #  SupF  stat  #          
tests <- rbind(lc,meanf,supf)

# Calculate p-value #
testx <- cbind(tests^0,tests^1,tests^2,tests^3)
k <- max(rbind(k1,k2))
m2 <- p2 - max(rbind((k2-k1),0))
n <- m2*3 + k
pvlc <- t(as.matrix(testx[1,]))%*%as.matrix(fmcrit[n,9:12])
pvmf <- t(as.matrix(testx[2,]))%*%as.matrix(fmcrit[n,5:8])
pvsf <- t(as.matrix(testx[3,]))%*%as.matrix(fmcrit[n,1:4])
pv <- rbind(pvlc,pvmf,pvsf)
pvh <- (pv < .01)
pv <- pv*(1-pvh) + pvh*.01
pvl <- (pv > .2)
pv <- pv*(1-pvl) + pvl*.2
tests <- cbind(tests,pv)
}else{
f <- 0
tests <- matrix(0,3,2)
}

u <- y - xt%*%b

if (poutput == 0){

cat ("Fully Modified Regression Results","\n")
cat ("Sample Size ", t,"\n")
cat ("\n")
cat ("Parameters Estimates are listed by row","\n")
cat ("Standard Errors are to the right of each estimate","\n")
cat ("\n")
cat ("I(1) variables","\n")
cat (b1,se[1:p2],"\n")
cat ("\n")
cat ("Constant, Trend, etc","\n")
for (j in 1:nrow(b2)) cat (b2[j]," ",se[p2+j],"\n")
cat ("\n")
cat ("Method of Estimation of Covariance Parameters:" ,"\n")
if (whiten == 0){
cat ("  Pre-Whitened","\n")
}else{
cat ("  Not Pre-Whitened","\n")
}
if (kernel == 1) cat ("  Quadratic Spectral kernel","\n")
if (kernel == 2) cat ("  Parzen kernel","\n")
if (kernel == 3) cat ("  Bartlett kernel","\n")
if (band == 0) cat ("  Automatic bandwidth selected : ", eband,"\n")
if (band < 0)  cat ("  Bandwidth set at 0","\n")
if (band > 0)  cat ("  Bandwidth set at ", eband,"\n")
cat ("\n")
cat ("\n")
cat ("Tests for Parameter Stability","\n")
cat ("\n")
cat ("       Test Statistic      P-value ('.20' means '>= .20')","\n")
cat ("LC    ", tests[1,1],"        ",tests[1,2],"\n")
cat ("MeanF ", tests[2,1],"        ",tests[2,2],"\n")
cat ("SupF  ", tests[3,1],"        ",tests[3,2],"\n")
}

list(b1=b1,b2=b2,v=v,u=u,f=f,tests=tests)
}

