%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
% MainFM.PRG

% Bruce E. Hansen
% Department of Economics
% Social Science Building
% University of Wisconsin
% Madison, WI 53706-1393
% bhansen@ssc.wisc.edu
% http://www.ssc.wisc.edu/~bhansen/

%      This is a Matlab program.
%      It will compute fully modified estimators of cointegrating relationships
%      and test for stability of such relationships.
%      This program calls a procedure which is in the file fm.prc.
%      The covariance parameters are calculated with the Quadratic Spectral kernel

%     The procedure fm() takes the form

%              fm(y,x,k1,k2)

% where
%         y  =  Dependent variable
%         x  =  Right Hand Side I(1) variables
%         k1 =  A non-negative integer.  It is the highest integer power of time
%               to be included in the regression equation.  For example, k1 = 0
%               means that a constant will be included.  k1 = 1 means that a
%               constant and a time trend will be included.

%         k2 =  A non-negative integer.  It is the highest integer power of time
%               which is believed to be describing the stochastic process of the
%               regressors  x.  For example, if x is believed to be I(1) plus
%               drift (differences of x have non-zero mean), then set k2 = 1.
%               If x is believed to be I(1) plus a quadratic trend, then set
%               k2 = 2.

%      The following global variables may be set           */

global whiten_;
global band_;
global kernel_;
global band_;
global tests_;
global out;
global poutput_;

whiten_ = 0;        %  Set at 0, covariances calculated by first pre-whitening
                    %    using a VAR(1).

                    %    Set at 1, pre-whitening not done */

kernel_ = 1;    %   Set at 1  -  Quadratic Spectral kernel is used
                %     Set at 2  -  Parzen kernel is used
                %     Set at 3  -  Bartlett kernel is used      */

band_ = 0 ;     %   Set at 0, covariances calculated using Andrews (1991)
                %         automatic bandwidth.  The weight matrix W is the
                %         identity matrix.  A VAR(1) model is used to calculate
                %         the automatic bandwidth.

                %         Set at a positive number, the bandwidth is set to
                %         this number.   

poutput_ = 0;       %   Set at 0, output is printed

                    %     Set at 1, output is not printed */

tests_ = 0;         %   Set at 0, test statistics are calculated

                    %     Set at 1, test statistics are not calculated */

fplot_ = 1;         %   Set at 1, plot of sequential F-tests will be done
                    %    (Requires that xy(.,.) function and pgraph be loaded) */

%  There are six output items passed back from the procedure:

% b1    = Fully modified estimates of the coefficients on the regressors  x .
% b2    = Fully modified estimates of the coefficients on the trend regressors.
%         These are order as follows:  constant, trend, quadratic ...
% v     = Fully modified covariance matrix for the vector (b1 b2).
% u     = Fully modified residuals.
% f     = Sequence of F-tests for model stability
% tests = Lc, SupF, and MeanF  (in that order)            

%    Example :  Empirical work in Hansen (1991) "Tests for parameter instability
%                in regressions with I(1) processes."           

load campbell.txt;
di=campbell(:,1);
tc=campbell(:,3);
nds=campbell(:,4);
load rates.txt;
ff=rates(:,1);
short=rates(:,2);
long=rates(:,3);
load stock.txt;
price=stock(:,1);
div=stock(:,2);

out=fopen('consmout.txt','wt');
fprintf(out,'Total Consumption upon Disposable Income, Linear\n\n');
[b1,b2,v,u,f,tests] = fm(tc,di,1,1);
fprintf(out,'\n\n');

if fplot_==1
    t=length(tc(:,1));
    firstob=1954.5+round(.15*t)/4;
    inc=.25;
    rf=length(f(:,1));
    qqx=(firstob:inc:(rf-1)*inc+firstob)';
    crit=ones(rf,1)*([15.2,6.22,7.815]);
    plot(qqx,f,qqx,crit(:,1),qqx,crit(:,2),qqx,crit(:,3));
    title('Total Consumption, 1953-1984');
    xlabel('Figure 1');
    ylabel('F stat');
    legend('F Statistic Sequence','0005% Critical, SupF','0005% Critical, MeanF','0005% Critical, Known Break');
    grid on;
    saveas(gcf,'figure1.eps','psc2');
end;

fprintf(out,'NDS Consumption upon Disposable Income, Linear\n\n');
[b1,b2,v,u,f,tests] = fm(nds,di,1,1);
fprintf(out,'\n\n');

if fplot_==1
    firstob=1872+round(.15*t);
    inc=1;
    rf=length(f(:,1));
    qqx=(firstob:inc:(rf-1)*inc+firstob)';
    crit=ones(rf,1)*([12.4,4.57,5.99]);
    plot(qqx,f,qqx,crit(:,1),qqx,crit(:,2),qqx,crit(:,3));
    title('NDS Consumption, 1953:1984');
    xlabel('Figure 2');
    ylabel('F stat');
    legend('F Statistic Sequence','0005% Critical, SupF','0005% Critical, MeanF','0005% Critical, Known Break');
    grid on;
    saveas(gcf,'figure2.eps','psc2');
end;
fclose(out);

out=fopen('stockout.txt','wt');
fprintf(out,'Stock Prices Upon Dividends, Linear\n\n');
[b1,b2,v,u,f,tests] = fm(price,div,0,0);
fprintf(out,'\n\n');

if fplot_==1
    t=length(price(:,1));
    firstob=1872+round(.15*t)/4;
    inc=1;
    rf=length(f(:,1));
    qqx=(firstob:inc:(rf-1)*inc+firstob)';
    crit=ones(rf,1)*([12.4,4.57,5.99]);
    plot(qqx,f,qqx,crit(:,1),qqx,crit(:,2),qqx,crit(:,3));
    title('Stock Prices and Dividends, 1871-1986');
    xlabel('Figure 3');
    ylabel('F stat');
    legend('F Statistic Sequence','0005% Critical, SupF','0005% Critical, MeanF','0005% Critical, Known Break');
    grid on;
    saveas(gcf,'figure3.eps','psc2');
end;

fprintf(out,'Stock Prices Upon Dividends, Logs\n\n');
[b1,b2,v,u,f,tests] = fm(log(price),log(div),0,0);
fprintf(out,'\n\n');

if fplot_==1
    firstob=1872+round(.15*t);
    inc=1;
    rf=length(f(:,1));
    qqx=(firstob:inc:(rf-1)*inc+firstob)';
    crit=ones(rf,1)*([12.4,4.57,5.99]);
    plot(qqx,f,qqx,crit(:,1),qqx,crit(:,2),qqx,crit(:,3));
    title('Logged Stock Prices and Dividends, 1871-1986');
    xlabel('Figure 4');
    ylabel('F stat');
    legend('F Statistic Sequence','0005% Critical, SupF','0005% Critical, MeanF','0005% Critical, Known Break');
    grid on;
    saveas(gcf,'figure4.eps','psc2');
end;
fclose(out);

out=fopen('ratesout.txt','wt');
fprintf(out,'Short Rates Upon Long Rates,  Nominal\n\n');
[b1,b2,v,u,f,tests] = fm(short,long,0,0);
fprintf(out,'\n\n');

if fplot_==1
    t=length(short(:,1));
    firstob=1960+round(.15*t)/12;
    inc=1/12;
    rf=length(f(:,1));
    qqx=(firstob:inc:(rf-1)*inc+firstob)';
    crit=ones(rf,1)*([12.4,4.57,5.99]);
    plot(qqx,f,qqx,crit(:,1),qqx,crit(:,2),qqx,crit(:,3));
    title('3-Month and 1-Year Treasury Bill Rates, 1960-1990');
    xlabel('Figure 5');
    ylabel('F stat');
    legend('F Statistic Sequence','0005% Critical, SupF','0005% Critical, MeanF','0005% Critical, Known Break');
    grid on;
    saveas(gcf,'figure5.eps','psc2');
end;

fprintf(out,'Short Rates Upon Federal Funds Rates\n\n');
[b1,b2,v,u,f,tests] = fm(short,ff,0,0);
fprintf(out,'\n\n');

if fplot_==1
    firstob=1960+round(.15*t)/12;
    inc=1/12;
    rf=length(f(:,1));
    qqx=(firstob:inc:(rf-1)*inc+firstob)';
    crit=ones(rf,1)*([12.4,4.57,5.99]);
    plot(qqx,f,qqx,crit(:,1),qqx,crit(:,2),qqx,crit(:,3));
    title('3-Month Treasury Bill and Federal Funds Rates, 1960-1990');
    xlabel('Figure 6');
    ylabel('F stat');
    legend('F Statistic Sequence','0005% Critical, SupF','0005% Critical, MeanF','0005% Critical, Known Break');
    grid on;
    saveas(gcf,'figure6.eps','psc2');
end;

fprintf(out,'Long Rates Upon Federal Funds Rates\n\n');
[b1,b2,v,u,f,tests] = fm(long,ff,0,0);
fprintf(out,'\n\n');

if fplot_==1
    firstob=1960+round(.15*t)/12;
    inc=1/12;
    rf=length(f(:,1));
    qqx=(firstob:inc:(rf-1)*inc+firstob)';
    crit=ones(rf,1)*([12.4,4.57,5.99]);
    plot(qqx,f,qqx,crit(:,1),qqx,crit(:,2),qqx,crit(:,3));
    title('1-Year Treasury Bill and Federal Funds Rates, 1960-1990');
    xlabel('Figure 7');
    ylabel('F stat');
    legend('F Statistic Sequence','0005% Critical, SupF','0005% Critical, MeanF','0005% Critical, Known Break');
    grid on;
    saveas(gcf,'figure7.eps','psc2');
end;

fclose(out);




    
