/*
This is a GAUSS program.  It executes the procedure
                fm(y,x,k1,k2)
which is explained in the example file fm.prg

Bruce E. Hansen
Department of Economics
Social Science Building
University of Wisconsin
Madison, WI 53706-1393
bhansen@ssc.wisc.edu
http://www.ssc.wisc.edu/~bhansen/

*/

proc (6) = fm(y,x,k1,k2);

local t,t1,t2,xt,y2,x2,xxi,xy,b,u2,xdx,p1,p2,p,j,u,ub,uf,a,e,te;
local eb,ef,ae,ee,se,f,a2,eband,jband,kern,jb,fmcrit;
local sig,lam,omega,uu,ai,delta,g,delg,fm,b1,b2,v,sg,tests,mj,ystar,a1;
local s,lc,sj,vj,meanf,supf,testx,n,pvlc,pvmf,pvsf,pv,pvh,pvl,m2,k,ad;

let fmcrit[14,12] =
1.9541680      -0.37328939      0.024575262   -0.00055327331
1.0800038      -0.51084717      0.084311339    -0.0047798770
0.92696063       -3.5355317        4.7711191       -2.2245239
2.4865556      -0.39952372      0.021931867   -0.00040957396
1.5952133      -0.61278630      0.081804512    -0.0037449886
1.1202840       -3.6436527        4.1553033       -1.6280553
1.9604138      -0.34958720      0.021313986   -0.00044199058
1.0078304      -0.47045939      0.077255740    -0.0043845742
0.76892894       -3.4322674        5.4713896       -3.0411469
2.6659636      -0.42367576      0.023031842   -0.00042656099
1.3855405      -0.50124110      0.062944545    -0.0027129772
0.99624428       -3.4929591        4.3105483       -1.8340943
3.4804277      -0.50535996      0.025031776   -0.00042113508
1.6410089      -0.47881034      0.047897512    -0.0016311073
1.1706978       -3.4207804        3.5068050       -1.2395319
3.1821750      -0.49111312      0.025771858   -0.00045780153
1.4766654      -0.55666440      0.072860224    -0.0032599448
0.85540501       -3.8286115        6.0850783       -3.3424818
3.6516493      -0.51068260      0.024292212   -0.00039149699
1.8184280      -0.56424493      0.060675193    -0.0022348862
1.0741719       -3.6581953        4.3577651       -1.7779576
4.0030156      -0.50787555      0.021889454   -0.00031953160
2.1207950      -0.55000703      0.048949379    -0.0014849560
1.2632400       -3.5111909        3.4037486       -1.1329408
2.8816090      -0.40327754      0.019278950   -0.00031407078
1.4477601      -0.39749377      0.037031003    -0.0011653953
1.2468682       -3.3928267        3.2354818       -1.0655657
3.2476994      -0.39699660      0.016346409   -0.00022599401
2.2209849      -0.57991932      0.051982832    -0.0015882815
1.4302220       -3.6226406        3.1846286      -0.95908418
4.4879269      -0.52308913      0.020630372   -0.00027457954
2.6404388      -0.60926610      0.047975889    -0.0012826061
1.4963005       -3.6364920        3.0747668      -0.89352493
3.5219212      -0.44902542      0.019392678   -0.00028297754
2.1623351      -0.56425294      0.050523709    -0.0015416765
1.4511468       -3.5147064        2.9424961      -0.84101131
4.0303937      -0.47157676      0.018728733   -0.00025195014
2.4396486      -0.55091334      0.042636952    -0.0011260605
1.6936335       -3.8351063        2.9919337      -0.79520273
5.3405143      -0.59430383      0.022404958   -0.00028524985
3.2870762      -0.70189574      0.051221375    -0.0012689016
1.7263214       -3.7289379        2.7922780      -0.71599348;

@ Construct Trends @
t = rows(y);
t1 = seqa(1,1,t);
t2 = t1[1:t-1].^(seqa(0,1,maxc(1|k2))');    @ trends in regressors @
t1 = t1.^(seqa(0,1,k1+1)');                 @ trends in regression @
xt = x~t1;
y2 = y[2:t,.];
x2 = xt[2:t,.];

@ OLS @
xxi = invpd(moment(x2,0));
xy = x2'y2;
b = xxi*xy;                                 @ OLS coefficients @
@ Construct u2 @
u2 = x[2:t,.] - x[1:t-1,.];
u2 = u2 - t2*((t2'u2)/moment(t2,0));        @ regressor innovation @
xdx = x2'u2;
p1 = cols(y);
p2 = cols(x);
p = p1 + p2;

u = (y2 - x2*b)~u2;                         @  Residuals            @

@ PreWhiten Residuals Using VAR(1)  @
if _whiten == 0;
 ub = u[1:t-2,.];
 uf = u[2:t-1,.];
 a = (ub'uf)/moment(ub,0);                     @ VAR(1) matrix @
 e = uf - ub*a;                                @ Whitened residuals @
 te = t-2;
else;
 e = u;
 te = t-1;
endif;

@ Select Bandwidth @

if _band == 0;
 eb = e[1:te-1,.];
 ef = e[2:te,.];
 ae = sumc(eb.*ef)./sumc(eb.^2);
 ee = ef - eb.*(ae');
 se = sqrt(meanc(ee.^2));
 ad = sumc((se./((1-ae).^2)).^2);
 a1 = 4*sumc((ae.*se./(((1-ae).^3).*(1+ae))).^2)/ad;
 a2 = 4*sumc((ae.*se./((1-ae).^4)).^2)/ad;
 if _kernel == 1;                               @  Quadratic Spectral @
  eband = 1.3221*((a2*te)^.2);
 elseif _kernel == 2;                           @  Parzen     @
  eband = 2.6614*((a2*te)^.2);
 elseif _kernel == 3;                           @  Bartlett   @
  eband = 1.1447*((a1*te)^.333);
 endif;
else;
 eband = _band;
endif;

@ Estimate Covariances @
jb = seqa(1,1,te-1)/eband;
if _kernel == 1;                                @ Quadratic Spectral Kernel @
  jband = jb*1.2*pi;
  kern = ((sin(jband)./jband - cos(jband))./(jband.^2)).*3;
elseif _kernel == 2;                            @  Parzen kernel @
  kern = (1 - (jb.^2)*6 + (jb.^3)*6).*(jb .<= .5);
  kern = kern + ((1-jb).^3).*(jb .<=1).*(jb .> .5)*2;
elseif _kernel == 3;                           @  Bartlett kernel @
  kern = (1-jb).*(jb .<= 1);
endif;

sig = e'e;
lam = zeros(p,p);
j = 1; do while j <=te-1;
  lam = lam + (e[1:te-j,.]'e[1+j:te,.])*kern[j];
j = j + 1; endo;
delta = sig + lam;
omega = sig + lam + (lam');
uu = u'u;

@ Recolor @
if _whiten == 0;
 ai = inv(eye(p) - a);
 omega = ai'omega*ai;
 delta = ai'delta*ai - ai'(a')*uu;
endif;

@ Fully Modified Estimation @
g = omega[2:p,1]/omega[2:p,2:p];
delg = delta[2:p,1] - delta[2:p,2:p]*g;
delg = delg|zeros(k1+1,p1);
ystar = y2 - u2*g;

b = xxi*((x2'ystar) - delg);
b1 = b[1:p2];
b2 = b[p2+1:rows(b)];

@  Covariance Matrix @
sg = (omega[1,1] - omega[1,2:p]*g)/(t-1);
v = xxi*sg;
u = ystar - x2*b;
se = sqrt(diag(v));

if _tests == 0;
@  Stability Test Statistics  @
s = x2.*u - ((delg')/(t-1));            @  Scores               @
s = cumsumc(s);                         @  Cummulative Scores   @
lc = sumc(diag( (s's) * xxi ))/(sg*(t-1));    @  LC test          @
t1 = round(t*.15);                  @  Trimming             @
t2 = round(t*.85);
f = zeros(t2-t1+1,1);
j = t1; do while j <= t2;
  sj = s[j,.]';                        @  j'th score           @
  vj = moment(x2[1:j,.],0);
  mj = vj - vj*xxi*vj;
  f[j-t1+1] = sj'invpd(mj)*sj;             @  j'th f-stat          @
j = j + 1; endo;

f = f./sg;
meanf = meanc(f);                   @  MeanF stat           @
supf = maxc(f);                     @  SupF  stat           @
tests = lc|meanf|supf;

@ Calculate p-value @;
testx = tests.^(seqa(0,1,4)');
k = maxc(k1|k2);
m2 = p2 - maxc((k2-k1)|0);
n = m2*3 + k;
pvlc = testx[1,.]*(fmcrit[n,9:12]');
pvmf = testx[2,.]*(fmcrit[n,5:8]');
pvsf = testx[3,.]*(fmcrit[n,1:4]');
pv = pvlc|pvmf|pvsf;
pvh = (pv .< .01);
pv = pv.*(1-pvh) + pvh*.01;
pvl = (pv .> .2);
pv = pv.*(1-pvl) + pvl*.2;
tests = tests~pv;

else;
f = 0;
tests = zeros(3,2);
endif;
u = y - xt*b;

if _poutput == 0;

"Fully Modified Regression Results";
"Sample Size " t;
"";
"Parameters Estimates are listed by row";
"Standard Errors are to the right of each estimate";
"";
"I(1) variables";
b1~se[1:p2];
"";
"Constant, Trend, etc";
b2~se[p2+1:rows(b)];
"";
"Method of Estimation of Covariance Parameters:" ;
if _whiten == 0;
"  Pre-Whitened";
else;
"  Not Pre-Whitened";
endif;
if _kernel == 1;
"  Quadratic Spectral kernel";
elseif _kernel == 2;
"  Parzen kernel";
elseif _kernel == 3;
"  Bartlett kernel";
endif;
if _band == 0;
"  Automatic bandwidth selected : " eband;
elseif _band .< 0;
"  Bandwidth set at 0";
else;
"  Bandwidth set at " eband;
endif;
"";"";
"Tests for Parameter Stability";
"";
"       Test Statistic      P-value ('.20' means '>= .20')";
"LC    " tests[1,.];
"MeanF " tests[2,.];
"SupF  " tests[3,.];
endif;

retp(b1,b2,v,u,f,tests);
endp;

