/*
This Stata procedure runs the R source file rungma.R inside Stata.
The R source file "rungma.R" computes the Mallows Model Average (MMA) 
and the Jackknife Model Average (JMA) least-squares estimates.

written by
Bruce E. Hansen
Department of Economics
University of Wisconsin


Format:

run "Z:\\rsource.ado"

global Rterm_path `"c:\Program Files\R\R-2.12.0\bin\i386\Rterm.exe"'

global Rterm_options `"--vanilla"'

rsource using "Z:\\rungma.R"
         

Outputs:

betahat: the model averaging estimates
weight: the weights for each models


Notes: (1) The user should change the global Rterm_path if the user downloads 
           a new version of R or the R path is not set to its correct value. 
           (See Technical note in help for rsource.)

       (2) The R output is listed to the Stata results window. Also, the results 
           are saved in two files, betahat.dat and weight.dat.

*/


clear

clear matrix

set mem 500m

set more off

capture log close

log using "Z:\\gma.log", replace

run "Z:\\rsource.ado"

global Rterm_path `"c:\Program Files\R\R-2.12.0\bin\i386\Rterm.exe"'

global Rterm_options `"--vanilla"'

rsource using "Z:\\rungma.R"






