% EL.PRG 

%Empirical Likelihood Estimation and Testing and Confidence 
%Interval Program

%written by:

%Bruce E. Hansen
%Department of Economics
%Social Science Building
%University of Wisconsin
%Madison, WI 53706-1393
%bhansen@ssc.wisc.edu
%http://www.ssc.wisc.edu/~bhansen/

%This program calculates empirical likelihood estimates and 
%tests of nonlinear hypotheses in GMM-type moment models.
%It also constructs profile confidence intervals.

%The empirical likelihood is optimized using the CONSTRAINED 


%The user needs to provide a procedure "_moments" which 
%computes the moments,
%and provide a vector of starting values "_beta0".

%To test a hypothesis, the user needs to provide a procedure 
%"h_test" which is a (nonlinear) function
%of the parameter b, which is a zero vector under the null 
%hypothesis.

%To construct a confidence interval for a parameter of 
%interest, the use needs to provide a procedure "h_theta" 
%which
%computes this parameter from the entire parameter vector.

%Format of Procedures:

%m=_moments(b);
%Input: 	b	kx1 parameter vector
%Output:	m	nxm matrix of "moment conditions".  Rows 
%(columns) correspond to observations (moment conditions).
%Example:		proc _moments(b); retp(x.*(y-z*b)); 
%endp;

%h=h_test(b);
%Input: 	b	kx1 parameter vector
%Output:	h	rx1 vector of constraints.  Should be zero 
%under H0
%Example:		proc h_test(b); retp(b[1]+b[2]-2); 
%endp;

%theta=h_theta(b);
%Input: 	b	kx1 parameter vector
%Output:	theta	1x1 parameter
%Example:		proc h_theta(b); retp(b[1]+b[2]); 
%endp;

%_beta0= kx1 	initial value for parameter vector


%The user may also select the following :   **************/
function main()
global testh0_;testh0_=0;		% Set to 1 to test the hypothesis in "h_test", else set to 0 to not do test @
out = fopen('elout.txt','wt');	% Name of output file %
global graph_;graph_=1;		% Set to 1 to compute and display profile criterion, else set to 0 @
global cregion_;cregion_=1;	 % Set to 1 to compute confidence region for "theta" @
global level_;level_=.90;		% Level of confidence region, if computed @
global grid_;grid_=21;		% Number of gridpoints for graph of profile criterion, if computed @
global lambda;
global fixalpha;

% Example data set %
load el.txt;
global y; y=el(:,1);
global z; z=el(:,2:3);
global x; x=el(:,4:7);
global testh__;
global region__;

beta0_=(((z'*x)*inv(x'*x)*(x'*y))'/((z'*x)*inv(x'*x)*(x'*z))')';
% Procedure start here %

e=moments_(beta0_);
global m;global n;global k;
[n,m]=size(e);k=length(beta0_);
global lambda;
names_='Beta1__';
for i=2:k
    names_=[names_;strcat('Beta',num2str(i),'__')];
end;
names2='Lambda1';        
for i=2:m
    names2=[names2;strcat('Lambda',num2str(i))];
end;
names2=[names_;names2];
lambda=zeros(m,1);

alpha0_=[beta0_;lambda];



%coset;
%trap 4;
%_co_ParNames=_names2;
%_co_MaxIters=500; 
%_co_IneqProc=&_pp;
%_co_GradProc=&_grad_el;
%_co_HessProc=&_hess_el;
%_co_EqProc = &_p_mo;
%@string _co_Options={stepbt newton forward none};@

testh__=0;
region__=0;

option=optimset('MaxIter',500);
[alpha,l0,ret]=fmincon(@el_,alpha0_,[],[],[],[],[],[],@nonlcon,option);


beta=alpha(1:k);
lambda=alpha(k+1:k+m);
e=moments_(beta);
p=1./(n*(1+e*lambda));
g=gradv_moment(beta);
gg=zeros(m,k);ee=zeros(m,m);
j=1; 
while j<=n;
    gg=gg+g((j-1)*m+1:(j-1)*m+m,:).*p(j);
    ee=ee+(e(j,:)'*e(j,:)).*p(j);
    j=j+1;
end;
v=inv(gg'*inv(ee)*gg)/n;
se=sqrt(diag(v));
lr=2*(l0-n*log(n));

fprintf(out,'Empirical Likelihood Estimation\n\n');
fprintf(out,'Unconstrained Estimation\n\n');
fprintf(out,'Variable     Estimate     St Error\n');
for i=1:length(beta)
    fprintf(out,'%s   %f   %f\n',names_(i,:),beta(i),se(i));
end;
fprintf(out,'Negative Log Empirical Likelihood\n %f \n',l0);
fprintf(out,'ELR Test of Over-Identifying Restrictions\n');
fprintf(out,'Test     dof     P_Value\n');
fprintf(out,'%f   %f   %f\n',lr,(m-k),chi2cdf(lr,m-k));

if testh0_==1
    h=h_test(beta);
    r=length(h(:,1));
    hh=gradh_test(beta)';
    seh=sqrt(diag(hh'*v*hh));

    testh__=1;
    [alpha1,l1,ret]=fmincon(@el_,alpha,[],[],[],[],[],[],nonlcon);
    testh__=0;
    beta1=alpha1(1:k);
    lambda1=alpha1(k+1:k+m);
    e=moments_(beta1);
    p=1./(n*(1+e*lambda1));
    g=gradv_moment(beta1);
    gg=zeros(m,k);ee=zeros(m,m);
    j=1; 
    while j<=n;
        gg=gg+g((j-1)*m+1:(j-1)*m+m,:).*p(j);
        ee=ee+(e(j,:)'*e(j,:)).*p(j);
        j=j+1;
    end;
    v1=inv(gg'*inv(ee)*gg)/n;
    hh=gradh_test(beta1)';
    v2=v1-v1*hh*inv(hh'*v1*hh)*(hh'*v1);
    se=sqrt(diag(v2));
    lr=2*(l1-n*log(n));
    lr1=2*(l1-l0);
    
    fprintf(out,'Estimated value of h(beta), s.e. s');
    for i=1:length(h)
        fprintf(out,'%f   %f\n',h(i),seh(i));
    end;
    fprintf(out,'**************************************************\n\n');
    fprintf(out,'Constrained Estimation\n\n');
    fprintf(out,'Variable     Estimate     St Error\n');
    for i=1:length(beta1)
        fprintf(out,'%s   %f   %f\n',names1(i,:),beta1(i),se(i));
    end;
    fprintf(out,'Negative Log Empirical Likelihood\n %f\n\n',l1);
    fprintf(out,'ELR Test of Over-Identifying Restrictions\n');
    fprintf(out,'Test     dof     P_Value\n');
    fprintf(out,'%f   %f   %f\n',lr1,r,chi2cdf(lr1,r));
end;

%********************************%
graph_=1;
cregion_=0;
if (graph_==1)+(cregion_==1)
    region__=1;
    thetahat=h_theta(beta);
    hh=gradh_theta(beta)';
    setheta=sqrt(diag(hh'*v*hh));
    if graph_==1;
        [c1,c2]=graph_el(thetahat,setheta,alpha);
    else;
        c1=c_solve(thetahat,setheta,alpha,1);
        c2=c_solve(thetahat,setheta,alpha,2);
    end;
    fprintf(out,'Estimates and Confidence Interval for Parameter of Interest\n');
    fprintf(out,'Theta     s.e.     C1     C2\n');
    fprintf(out,'%f   %f   %f    %f\n',thetahat,setheta,c1,c2);
end;
fclose(out);

function e=moments_(b);
global y;
global z;
global x;
e=x.*((y-z*b)*ones(1,length(x(1,:))));

% Test of Non-Linear Restrictions @
function h=h_test(b);
global testh0_;
if testh0_==1;
    h=b(1)+b(2)-2;
else;
    h=NaN;
end;

function g=gradh_test(beta);
tiny=0.00001;
p=h_test(beta);
for i=1:length(beta)
    beta1=beta;beta1(i)=beta(i)-tiny;
    beta2=beta;beta2(i)=beta(i)+tiny;
    if i==1
        g=((h_test(beta2)-h_test(beta1))/(2*tiny))';
    else
        g=[g,((h_test(beta2)-h_test(beta1))/(2*tiny))'];
    end;
end;

% Parameter of Interest: Theta @
function h=h_theta(b);
global graph_;
global cregion_;
if (graph_==1)+(cregion_==1);
    h=b(1)+b(2);
else;
    h=NaN;
end;

function g=gradh_theta(beta);
tiny=0.00001;
p=h_theta(beta);
for i=1:length(beta)
    beta1=beta;beta1(i)=beta(i)-tiny;
    beta2=beta;beta2(i)=beta(i)+tiny;
    if i==1
        g=((h_theta(beta2)-h_theta(beta1))/(2*tiny))';
    else
        g=[g,((h_theta(beta2)-h_theta(beta1))/(2*tiny))'];
    end;
end;
% PROCS %
function [l,gr,hess]=el_(alpha);
global m;
global n;
global k;
pv=(moments_(alpha(1:k))*alpha(k+1:k+m)+1)*n;
if min(pv)> 0;
    l=sum(log(pv));
else;
    l=n*log(n);
end;
gr=grad_el_(alpha);
hess=hess_el_(alpha);

function l=el2_(beta);
global m;
global n;
global k;
global lambda;
lambda0=lambda;
pv=(moments_(beta)*lambda0+1)*n;
if min(pv)> 0;
    l=sum(log(pv))';
else;
    l=n*log(n);
end;

function g=gradel2(beta)
tiny=0.00001;
p=el2_(beta);
for i=1:length(beta)
    beta1=beta;beta1(i)=beta(i)-tiny;
    beta2=beta;beta2(i)=beta(i)+tiny;
    if i==1
        g=((el2_(beta2)-el2_(beta1))/(2*tiny))';
    else
        g=[g,((el2_(beta2)-el2_(beta1))/(2*tiny))'];
    end;
end;

function h=hessel2(beta)
tiny=0.00001;
p=gradel2(beta);
for i=1:length(beta)
    beta1=beta;beta1(i)=beta(i)-tiny;
    beta2=beta;beta2(i)=beta(i)+tiny;
    if i==1
        h=(gradel2(beta2)-gradel2(beta1))/(2*tiny);
    else
        h=[h;(gradel2(beta2)-gradel2(beta1))/(2*tiny)];
    end;
end;
    

function g=grad_l_(beta);
global lambda;
lambda0=lambda;
e=moments_(beta);
g=sum(e./((e*lambda0+1)*ones(1,length(e(1,:)))))';

function g=grad_grad_l_(beta);
tiny=0.00001;
p=grad_l_(beta);
for i=1:length(beta)
    beta1=beta;beta1(i)=beta(i)-tiny;
    beta2=beta;beta2(i)=beta(i)+tiny;
    if i==1
        g=((grad_l_(beta2)-grad_l_(beta1))'/(2*tiny))';
    else
        g=[g,((grad_l_(beta2)-grad_l_(beta1))'/(2*tiny))'];
    end;
end;

function g=grad_el_(alpha);
global m;
global n;
global k;
global lambda;
beta=alpha(1:k);
lambda0=alpha(k+1:k+m);
lambda=lambda0;
g1=gradel2(beta)';
g2=grad_l_(beta);
g=[g1;g2];
if length(alpha(:,1))>length(g(:,1));
    g=[g;zeros(length(alpha(:,1))-length(g(:,1)),1)];
end;

function h=hess_el_(alpha);
global m;
global n;
global k;
global lambda;
beta=alpha(1:k);
lambda0=alpha(k+1:k+m);
lambda=lambda0;
h=zeros(size(alpha));
h(1:k,1:k)=hessel2(beta);
h(k+1:k+m,1:k)=grad_grad_l_(beta);
h(1:k,k+1:k+m)=h(k+1:k+m,1:k)';
e=moments_(beta);
g=e./((e*lambda0+1)*ones(1,length(e(1,:))));
h(k+1:k+m,k+1:k+m)=g'*g;

function g=p_mo_(alpha);
global m;
global n;
global k;
global testh__;
global region__;
e=moments_(alpha(1:k));
pv=(e*alpha(k+1:k+m)+1)*n;
p=1./pv;
g=(e'*p);
if testh__==1;
    g=[g;h_test(alpha(1:k))];
end;
if region__==1;
    g=[g;(h_theta(alpha(1:k))-alpha(k+m+1))];
end;

function v=v_moment(b);
mb=moments_(b);
for i=1:length(mb(:,1))
    if i==1
        v=mb(i,:)';
    else
        v=[v;mb(i,:)'];
    end;
end;

function g=gradv_moment(beta);
tiny=0.00001;
p=v_moment(beta);
for i=1:length(beta)
    beta1=beta;beta1(i)=beta(i)-tiny;
    beta2=beta;beta2(i)=beta(i)+tiny;
    if i==1
        g=((v_moment(beta2)-v_moment(beta1))'/(2*tiny))';
    else
        g=[g,((v_moment(beta2)-v_moment(beta1))'/(2*tiny))'];
    end;
end;

function pv=pp_(alpha);
global m;
global n;
global k;
pv=((moments_(alpha(1:k))*alpha(k+1:k+m)+1)*n-1);

function [c,ce] = nonlcon(x)
c=-pp_(x);
ce=p_mo_(x);

function [l,aa,ret]=constr_(theta,alpha);
global fixalpha;
fixalpha=[alpha;theta];
r=length(alpha(:,1));
%co_Active_=[ones(r,1);0];
warning off;
option=optimset('MaxIter',500,'TolFun',0.5);
[a,l,ret]=fmincon(@el_,[alpha;theta],[],[],[],[],[],[],@fnonlcon,option);
warning on;
aa=a(1:r);

function [c1,c2]=graph_el(thetahat,setheta,alpha0)
global level_;
global grid_;
cr=chi2inv(level_,1);
a0=alpha0;
lr=0;j=0;
l0=el_(alpha0);
while lr < (cr+1)
    lr
    cr+1
    j=j+1;
    theta0=thetahat-setheta*j;
    [l1,a0,ret]=constr_(theta0,a0);
    lr=2*(l1-l0);
end;
theta1=theta0;
a0=alpha0;
lr=0;j=0;
while lr < (cr+1)
    lr
    cr+1
    j=j+1;
    theta0=thetahat+setheta*j;
    [l1,a0,ret]=constr_(theta0,a0);
    lr=2*(l1-l0);
end;
theta2=theta0;
aa=(theta1:(theta2-theta1)/(grid_-1):theta2);
lrs=zeros(grid_,1);
for i=grid_:-1:1
    i
    theta0=aa(i);
    [l1,a0,ret]=constr_(theta0,a0);
    lr=2*(l1-l0);
    lrs(i)=lr;
end;
z=ones(grid_,1)*cr;
d=(lrs<cr);
[temp,d1]=max(d); 
[temp,d2]=max(d((length(d):-1:1)));
d2=grid_+1-d2;
c1a=aa(d1-1);
c1b=aa(d1);
c1=((lrs(d1-1)-cr)*c1b+(cr-lrs(d1))*c1a)/(lrs(d1-1)-lrs(d1));
lrs
c2a=aa(d2);
c2b=aa(d2+1);
c2=((lrs(d2+1)-cr)*c2a+(cr-lrs(d2))*c2b)/(lrs(d2+1)-lrs(d2));

lev=num2str(level_*100)
tit1=strcat(lev,'% Empirical Likelihood Confidence Interval for Theta');
tit2=strcat('Profile EL Criterion and  ',lev,'% Critical Value');
plot(aa,[lrs,z]);
title(tit1);
xlabel('Theta');
ylabel(tit2);
saveas(gcf,'elike.eps','psc2');


function theta=c_solve(thetahat,setheta,alpha0,endpoint);
global level_;
global grid_;
gg=0; 
g_l=0;  
theta_l=thetahat; 
g_r=0;  
theta_r=thetahat; 
theta=thetahat;
a0=alpha0;
cr=chi2inv(level_,1);
if endpoint==1; 
    sn=-1; 
elseif endpoint==2; 
    sn=1;
end;
dtheta=sqrt(cr)*setheta*.6*sn;  
l0=el_(alpha0);
nogo=1;
for j=1:100
    theta=theta+dtheta;
    [l1,a0,ret]=constr_(theta,a0);
    lr=2*(l1-l0);
    if ret>2
        theta=theta-dtheta;
        dtheta=dtheta/2;
        a0=alpha0;
    else;
        gg=lr; 
        theta_l=theta_r;
        g_l=g_r;
        theta_r=theta;
        g_r=gg;
    end;
    try_ =(abs(cr-gg)<.01)+(gg>cr);
    if try_==1;
            nogo=0; 
            break;
    end;
end;
if nogo~=1
    try_=(abs(cr-g_r)<.01)+(abs(theta_l-theta_r)<.000001);
    if try_~=1
        a1=a0; nogo=1;
        for j=1:20
            theta=(theta_l+theta_r)/2;
            [l1,a1,ret]=constr_(theta,a1);
            lr=2*(l1-l0);
            if ret>2;
                [l1,a1,ret]=constr_(theta,a0);
                lr=2*(l1-l0);
            end;
            if lr>cr;
                theta_r=theta; g_r=lr;
            else;
                theta_l=theta; g_l=lr;
            end;
            try_= (abs(cr-lr)<.01)+(abs(theta_l-theta_r)<.000001);
            if try_==1; 
                nogo=0; 
                break; 
            end;
            theta=(theta_l*(g_r-cr)+theta_r*(cr-g_l))/(g_r-g_l);
            [l1,a1,ret]=constr_(theta,a1);
            lr=2*(l1-l0);
            if ret>2;
                [l1,a1,ret]=constr_(theta,a0);
                lr=2*(l1-l0);
            end;
            if lr>cr;
               theta_r=theta; g_r=lr;
            else;
               theta_l=theta; 
               g_l=lr;
            end;
            try_= (abs(cr-lr)<.01)+(abs(theta_l-theta_r)<.000001);
            if try_==1; 
                nogo=0; 
                break; 
            end;
        end; 
    end;
end;

function [c,ce] = fnonlcon(x)
global fixalpha;
r=length(fixalpha);
c=-pp_(x);
ce=abs(p_mo_(x))+abs(x(r)-fixalpha(r));
