%********************************************************
%GDP.M

%written by
%Bruce E. Hansen
%Department of Economics
%University of Wisconsin
%www.ssc.wisc.edu/~bhansen

%This Gauss program replicates the empirical work reported in my paper
%"Nonparametric Estimation of Smooth Conditional Distributions".

%This version: 5/27/2004


%This program uses the procedure file "cdf.prc"

%*********************************************************/
function gdp()
load gdpq.txt;
dat=gdpq(148:length(gdpq(:,1)));

n=length(dat(:,1))-2;
dat=log(dat)*400;
y=dat(3:n+2)-dat(2:n+1);
x=dat(2:n+1)-dat(1:n);
xx=[ones(n,1),x];
beta=(y'/xx')';
sig=sqrt(mean((y-xx*beta).^2)');

s=(-2:.02:500*.02-2)';

t1=2;
yf1=beta(1)+t1*beta(2);
yf1
n1=normcdf((s-yf1)./sig,0,1);
[ll1,a1]=LL_CDF(y,x,s,t1);
[sll1,h1,b1]=SLL_CDF(y,x,s,t1);

t2=4.5;
yf2=beta(1)+t2*beta(2);
n2=normcdf((s-yf2)./sig,0,1);

[ll2,a2]=LL_CDF(y,x,s,t2);
[sll2,h2,b2]=SLL_CDF(y,x,s,t2);

out=fopen('gdpout.txt','wt');
fprintf(out,'t1=%f\n',t1);
fprintf(out,'a=%f\n',a1);
fprintf(out,'b=%f\n',b1);
fprintf(out,'h=%f\n\n',h1);
fprintf(out,'t2=%f\n',t2);
fprintf(out,'a=%f\n',a2);
fprintf(out,'b=%f\n',b2);
fprintf(out,'h=%f\n',h2);
fclose(out);

plot(s,n1,'k:',s,ll1,'k-',s,sll1,'k--');
ylabel('Conditional Distribution Function');
title('Figure 1: Estimated Conditional Distribution of U.S. GDP Growth Conditional on Current Rate = 2%');
legend('Gaussian AR(1) Estimate','Local Linear Estimator','Smoothed Local Linear Estimator','Location','NorthWest');
xlim([-1 7]);
ylim([0 1]);
saveas(gcf,'fig1.eps','psc2');
plot(s,n2,'k:',s,ll2,'k-',s,sll2,'k--');
ylabel('Conditional Distribution Function');
title('Figure 2: Estimated Conditional Distribution of U.S. GDP Growth Conditional on Current Rate = 4.5%');
legend('Gaussian AR(1) Estimate','Local Linear Estimator','Smoothed Local Linear Estimator','k--','Location','NorthWest');
xlim([-1 7]);
ylim([0 1]);
saveas(gcf,'fig2.eps','psc2');


%********************************************************
%CDF.M

%written by
%Bruce E. Hansen
%Department of Economics
%University of Wisconsin
%www.ssc.wisc.edu/~bhansen

%This Matlab program implements the methods reported in my paper
%"Nonparametric Estimation of Smooth Conditional Distributions".



%There are three procedures given here: LL_CDF, SLL_CDF, and MSE_TILDE

%*****************************************************************

%LL_CDF

%Estimates the conditional distribution function of Y given X, F(s|t)
%using a Local Linear Estimator

%The bandwidth is selected by an empirical plug-in rule.

%format:
%{cdf,b}=LL_CDF(y,x,s,t)

%inputs:
%y	Dependent variable 			nx1
%x	Regressor				nx1
%s	points of evaluation for y		rx1
%t	points of evaluation for x		1x1

%outputs:
%cdf	Conditional Distribution Function	kx1
%b	Bandwidth 				1x1

%*****************************************************************

%SLL_CDF

%Estimates the conditional distribution function of Y given X, F(s|t)
%using a Smoothed Local Linear Estimator

%The bandwidth is selected by an empirical plug-in rule.  The function
%MSE_TILDE (see below) is minimizes over possible bandwidths. 
%The internal GAUSS routine QNEWTON is used to minimize the function.

%format:
%{cdf,h,b}=SLL_CDF(y,x,s,t)

%inputs:
%y	Dependent variable 			nx1
%x	Regressor				nx1
%s	points of evaluation for y		rx1
%t	points of evaluation for x		1x1

%outputs:
%cdf	Conditional Distribution Function	kx1
%h	Bandwidth for y				1x1
%b	Bandwidth for x				1x1

%*****************************************************************

%MSE_TILDE

%Estimates the asymptotic MSE of the SLL estimator as a function of transformed
%bandwidths.  This procedure is called and minimized by SLL_CDF to implement 
%the bandwidth selection rule.  It relies on the globals
%ghat_,vtilde_,v1tilde_,V2hat_,v3hat_,ht_,n_,output_
%which are declared in the first line below.  The bandwidths are transformed to
%impose positivity and bounding constraints.

%******************************************************************/
function [cdf,b]=LL_CDF(y,x,s,t);
global ghat_;global vtilde_;global v1tilde_;global v2hat_;global v3hat_;global ht_;global n_;global output_;
n=length(y(:,1));
p=5;		% polynomial order for parametric approx @
xt=x-t;  
sx=std(x)';
shat=1.06*sx/(n^(.2));
that=.94*sx/(n^(1/9));
ghat1=(mean(normpdf(xt/shat,0,1))/shat')';
xtt=(xt'/that');
g2hat=(mean(normpdf(xtt.*(that.^2-1),0,1))/(that.^3)')';
rhat=(ghat1/2/sqrt(pi)/(g2hat^2)/n).^(1/9);
ghat_=(mean(normpdf(xt/rhat,0,1))/rhat')';

x0=ones(n,1)/n;
xp=(xt*ones(1,p+1)).^(ones(length(xt(:,1)),1)*(0:p));

x1=xp(:,[1 2]);
x3=xp(:,1:4);


mw=(' ');
warning off;
xpp=xp*inv(xp'*xp);
[mw,idw] = lastwarn;
lastwarn(' ');
warning on;
if mw~=' '
    xpp=xp*pinv(xp'*xp);
end;

yp=y*ones(1,length(y))-ones(length(y),1)*y';
yp=yp.*(yp>0);
v=xpp'*yp*xpp;
vhat=abs(v(1,1));

nn=ones(n,1);
ynn=y*(nn');
y1=ynn(1,:);
for ii=2:length(y(:,1))
    y1=[y1,ynn(ii,:)];
end;
nny=nn*(y');
y2=nny(1,:);
for ii=2:length(nny(:,1))
    y2=[y2,nny(ii,:)];
end;
%Reshape%
temp=max([y1;y2])';
ym=temp(1:n)';
for ii=1:(n-1)
    ym=[ym;temp((ii*n)+1:ii*n+n)'];
end;

v=xpp'*ym*xpp;
v1hat=abs(v(3,3));
v=xpp'*ym*xpp;
v4hat=abs(v(5,5));

q0=.78*((vhat/ghat_/v1hat/n).^(.2));
w0=normpdf((xt'/q0')',0,1);
mw=(' ');
warning off;
m1=inv(x1'*((w0*ones(1,length(x1(1,:)))).*x1));
[mw,idw] = lastwarn;
lastwarn(' ');
warning on;
if mw~=' '
    m1=pinv(x1'*((w0*ones(1,length(x1(1,:)))).*x1));
end;
x1=((w0*ones(1,length(x1(1,:)))).*x1)*m1;
v=x1'*yp*x1;
vtilde_=abs(v(1,1));

q1=1.01*((vhat/ghat_/v4hat/n).^(1/9));
w1=normpdf(xt/q1,0,1);
mw=(' ');
warning off;
m3=inv(x3'*((w1*ones(1,length(x3(1,:)))).*x3));
[mw,idw] = lastwarn;
lastwarn(' ');
warning on;
if mw~=' '
    m1=pinv(x3'*((w1*ones(1,length(x3(1,:)))).*x3));
end;
x3=((w1*ones(1,length(x3(1,:)))).*x3)*m3;
v=x3'*ym*x3;
v1tilde_=abs(v(3,3));

% Bandwidth for Local Linear Estimation %
b=.78*((vtilde_/ghat_/v1tilde_/n).^(.2));
w=normpdf(xt./b,0,1);
beta=((xt'*w)'/((xt.^2)'*w)')';
w=w.*(1-xt*beta).*(xt*beta<1);
w=w./sum(w)';
cdf=(y*ones(1,length(s)) <= ones(length(y),1)*s')'*w;

function [cdf,h,b]=SLL_CDF(y,x,s,t);
global ghat_;global vtilde_;global v1tilde_;global v2hat_;global v3hat_;global ht_;global n_;global output_;
n=length(y(:,1)); n_=n;
p=5;		% polynomial order for parametric approx @
xt=x-t;  
sx=std(x)';
shat=1.06*sx/(n^(.2));
that=.94*sx/(n^(1/9));
ghat1=(mean(normpdf(xt/shat,0,1))/shat')';
xtt=(xt'/that');
g2hat=(mean(normpdf(xtt.*(that.^2-1),0,1))/(that.^3)')';
rhat=(ghat1/2/sqrt(pi)/(g2hat^2)/n).^(1/9);
ghat_=(mean(normpdf(xt/rhat,0,1))/rhat')';

x0=ones(n,1)/n;
xp=(xt*ones(1,p+1)).^(ones(length(xt(:,1)),1)*(0:p));

x1=xp(:,[1 2]);
x3=xp(:,1:4);


mw=(' ');
warning off;
xpp=xp*inv(xp'*xp);
[mw,idw] = lastwarn;
lastwarn(' ');
warning on;
if mw~=' '
    xpp=xp*pinv(xp'*xp);
end;

yy=y*ones(1,length(y))-ones(length(y),1)*y';
yp=yy.*(yy>0);
v=xpp'*yp*xpp;
vhat=abs(v(1,1));

nn=ones(n,1);
ynn=y*(nn');
y1=ynn(1,:);
for ii=2:length(y(:,1))
    y1=[y1,ynn(ii,:)];
end;
nny=nn*(y');
y2=nny(1,:);
for ii=2:length(nny(:,1))
    y2=[y2,nny(ii,:)];
end;
%Reshape%
temp=max([y1;y2])';
ym=temp(1:n)';
for ii=1:(n-1)
    ym=[ym;temp((ii*n)+1:ii*n+n)'];
end;

v=xpp'*ym*xpp;
v1hat=abs(v(3,3));
v=xpp'*ym*xpp;
v4hat=abs(v(5,5));

q0=.78*((vhat/ghat_/v1hat/n).^(.2));
w0=normpdf((xt'/q0')',0,1);
mw=(' ');
warning off;
m1=inv(x1'*((w0*ones(1,length(x1(1,:)))).*x1));
[mw,idw] = lastwarn;
lastwarn(' ');
warning on;
if mw~=' '
    m1=pinv(x1'*((w0*ones(1,length(x1(1,:)))).*x1));
end;
x1=((w0*ones(1,length(x1(1,:)))).*x1)*m1;
v=x1'*yp*x1;
vtilde_=abs(v(1,1));

q1=1.01*((vhat/ghat_/v4hat/n).^(1/9));
w1=normpdf(xt/q1,0,1);
mw=(' ');
warning off;
m3=inv(x3'*((w1*ones(1,length(x3(1,:)))).*x3));
[mw,idw] = lastwarn;
lastwarn(' ');
warning on;
if mw~=' '
    m1=pinv(x3'*((w1*ones(1,length(x3(1,:)))).*x3));
end;
x3=((w1*ones(1,length(x3(1,:)))).*x3)*m3;
v=x3'*ym*x3;
v1tilde_=abs(v(3,3));

% DF Bandwidth Estimation -- from Hansen (2004) %
j=4;
r=gamma(j+1.5)/2/pi/(std(y)'.^(2*j+3));
for m=j:-1:1
    a=(gamma(m+.5)*(2^(m+.5))/pi/r/n)^(1/(2*m+3));
    u=(yy'/a')';
    h0=1;
    h1=u;
    for i=1:2*m-1
        hr=u.*h1-i*h0;
        h0=h1; h1=hr;
    end;
    r=abs(mean(mean(normpdf(u,0,1).*hr)')')/(a^(1+2*m));
end;
a=1/((sqrt(pi)*r*n)^(1/3));

phi=normpdf((yy'/a')',0,1)/a;
v=xpp'*phi*xpp;
v

v2hat_=v(3,1);

phi2=phi.*((yy/a).^2 - 1)/(a^2);
v=xpp'*phi2*xpp;
v3hat_=abs(v(1,1));

btilde=.78*((vtilde_/ghat_/v1tilde_/n).^(.2));
bh=[log(btilde);0];
bh
mse_tilde(bh)
ht_=sqrt(pi)*vtilde_/2;
[h,m]=fminsearch(@mse_tilde,bh);
b=exp(h(1));
h=(ht_/(1+exp(-h(2))));

w=normpdf(xt./b,0,1);
beta=((xt'*w)/((xt.^2)'*w));
w=w.*(1-xt*beta).*(xt*beta<1);
w=w./sum(w)';
% Numerical Approximation to Normal CDF %
u=(ones(length(y),1)*s'-y*ones(1,length(s)))./h;
c = [1.330274429 1.821255978 1.781477937 .356563782 .31938153];
t=1./(1+abs(u)*.2316419);
er = 1 - ((((c(1).*t-c(2)).*t+c(3)).*t-c(4)).*t+c(5)).*t.*normpdf(u,0,1);
k=(u==0)*(.5)+(u>0).*er+(u<0).*(1-er);
cdf=k'*w; 

function mh=mse_tilde(hh);
global ghat_;global vtilde_;global v1tilde_;global v2hat_;global v3hat_;global ht_;global n_;global output_;
b=exp(hh(1));
h=ht_/(1+exp(-hh(2)));
sqrtpi=sqrt(pi);
m1=(b.^4)*v1tilde_-2*(h.^2).*(b.^2).*v2hat_+(h.^4).*v3hat_;
mh=(vtilde_-h/sqrtpi)/(2*sqrtpi*ghat_*n_*b)+m1/4;

    
    
    