/********************************************************
GDP.PRC

written by
Bruce E. Hansen
Department of Economics
University of Wisconsin
www.ssc.wisc.edu/~bhansen

This Gauss program replicates the empirical work reported in my paper
"Nonparametric Estimation of Smooth Conditional Distributions".

This version: 5/27/2004


This program uses the procedure file "cdf.prc"

*********************************************************/
library pgraph;
pqgwin many;
#include cdf.prc;

load dat[]=gdpq.dat;
dat=dat[148:rows(dat)];

n=rows(dat)-2;
dat=ln(dat)*400;
y=dat[3:n+2]-dat[2:n+1];
x=dat[2:n+1]-dat[1:n];
xx=ones(n,1)~x;
beta=(y/xx);
sig=sqrt(meanc((y-xx*beta).^2));

s=seqa(-2,.02,501);

t1=2;
yf1=beta[1]+t1*beta[2];
n1=cdfn((s-yf1)./sig);
{ll1,a1}=ll_cdf(y,x,s,t1);
{sll1,h1,b1}=sll_cdf(y,x,s,t1);

t2=4.5;
yf2=beta[1]+t2*beta[2];
n2=cdfn((s-yf2)./sig);
{ll2,a2}=ll_cdf(y,x,s,t2);
{sll2,h2,b2}=sll_cdf(y,x,s,t2);

output file = gdp.out reset;
"t1 = " t1;
"a  = " a1;
"b  = " b1;
"h  = " h1;
""; 
"t2 = " t2;
"a  = " a2;
"b  = " b2;
"h  = " h2;
output off;

graphset;
ylabel("Conditional Distribution Function");
_pdate="";
_plwidth=3;
_pcolor=15;
ytics(0,1,.1,10);
xtics(-1,7,1,10);
fonts("complex");

_protate=1;
begwind;
window(2,1,0);
setwind(1);
let _plegctl= 1 6 -1 .81;
_plegstr="Gaussian AR(1) Estimate\000Local Linear Estimator\000Smoothed Local Linear Estimator";
let _pltype = 4 6 3;
title("Figure 1:\LEstimated Conditional Distribution of U.S. GDP Growth\LConditional on Current Rate = 2%");
xy(s,n1~ll1~sll1);
nextwind;
title("Figure 2:\LEstimated Conditional Distribution of U.S. GDP Growth\LConditional on Current Rate = 4.5%");
xy(s,n2~ll2~sll2);
endwind;


/****************************************************/
