% 	Table2.m
%	Replication file from Bruce E. Hansen 
%	Criterion-Based Inference Without the Information Equality: The Weighted Chi-Square Distribution
% 	Produces Table 2: Finite Sample Simulation
%	Calls function Farebrother

rep = 30000;
crit = 0.05;
boot = 1000;

nm = 4;
ns = [100,500];
qs = [2,5,8];
nn = length(ns);
nq = length(qs);
p1 = zeros(nm,nn*nq);
p2 = zeros(nm,nn*nq);
p3 = zeros(nm,nn*nq);
p4 = zeros(nm,nn*nq);
p5 = zeros(nm,nn*nq);
p6 = zeros(nm,nn*nq);
p7 = zeros(nm,nn*nq);
rng(4172021);

for m = 1:nm

for ni = 1:nn
  n = ns(ni);
for qi = 1:nq
  q = qs(qi);

store = zeros(rep,7);
for i = 1:rep

if (m==1)
  X1 = ones(n,1);
elseif (m==2)
  X1 = randn([n,1]);
elseif (m==3)
  nu = 6;
  X1 = trnd(nu,n,1)*sqrt((nu-2)/nu);
elseif (m==4)
  X1 = (exp(randn([n,1])/sqrt(3)) - exp(1/6))/sqrt(exp(2/3)-exp(1/3));
end
X2 = randn([n,q-1]);
X = [X1,X2];
Y = X1.*randn([n,1]);

XX = X'*X;
H = inv(XX);
Xe = X'*Y;
beta = H*Xe;
e = Y - X*beta;
sig2 = sum(e.^2)/(n-q);
F = (beta'*XX*beta)/sig2;
U = X.*(Y*ones(1,q));
omega = U'*U;
V = H*omega*H;
V0 = H*sig2;
lambda = eig(V,V0);
Q = 1 - Farebrother(F,lambda);
store(i,1) = (1 - fcdf(F/q,q,n-q) < crit);
store(i,2) = (Q < crit);
if (ismissing(Q)==1)  store(i,7) = 1; end

% Bootstrap
bstore3 = zeros(boot,1);
bstore4 = zeros(boot,1);
bstore5 = zeros(boot,1);
bstore6 = zeros(boot,1);
for b = 1:boot
  bi = randi(n,n,1);
  Xb = X(bi,:);
  Yb = Y(bi);
  XXb = Xb'*Xb;
  Hb = inv(XXb);
  Xeb = Xb'*Yb;
  betab = Hb*Xeb;
  eb = Yb - Xb*betab;
  sig2b = sum(eb.^2)/(n-q);
  Fb1 = (betab-beta)'*XXb*(betab-beta)/sig2b;
  Fb2 = (Xeb - Xe)'*Hb*(Xeb - Xe)/sig2b;
  er = Yb - Xb*beta;
  Ub = Xb.*(er*ones(1,q));
  omegab = Ub'*Ub;
  Vb = Hb*omegab*Hb;
  V0b = Hb*sig2b;
  lambdab = eig(Vb,V0b);
  bstore3(b,1) = Fb1;
  bstore4(b,1) = Fb2;
  bstore5(b,1) = 1 - Farebrother(Fb1,lambdab);
  bstore6(b,1) = 1 - Farebrother(Fb2,lambdab);
end
store(i,3) = (mean(bstore3 > F) < crit);
store(i,4) = (mean(bstore4 > F) < crit);
store(i,5) = (mean(bstore5 < Q) < crit);
store(i,6) = (mean(bstore6 < Q) < crit);

end

mstore = mean(store);

p1(m,qi+(ni-1)*nq) = mstore(1);
p2(m,qi+(ni-1)*nq) = mstore(2);
p3(m,qi+(ni-1)*nq) = mstore(3);
p4(m,qi+(ni-1)*nq) = mstore(4);
p5(m,qi+(ni-1)*nq) = mstore(5);
p6(m,qi+(ni-1)*nq) = mstore(6);
p7(m,qi+(ni-1)*nq) = mstore(7);

fprintf('F');
fprintf('\n');
disp(p1);
fprintf('Weighted Chi-Square');
fprintf('\n');
disp(p2);
fprintf('Regression-Based Bootstrap');
fprintf('\n');
disp(p3);
fprintf('Hall-Horowitz Bootstrap');
fprintf('\n');
disp(p4);
fprintf('Prepivot Regression-Based Bootstrap');
fprintf('\n');
disp(p5);
fprintf('Prepivot Hall-Horowitz Bootstrap');
fprintf('\n');
disp(p6);

end
end
end

diary('Table2.log');
fprintf('Simulation Replications');
disp(rep);
fprintf('Bootstrap Replications');
disp(boot);
fprintf('Critical Value Level');
disp(crit);
fprintf('Sample Sizes');
disp(ns);
fprintf('Number of Instruments');
disp(qs);
fprintf('F');
fprintf('\n');
disp(p1);
fprintf('Weighted Chi-Square');
fprintf('\n');
disp(p2);
fprintf('Regression-Based Bootstrap');
fprintf('\n');
disp(p3);
fprintf('Hall-Horowitz Bootstrap');
fprintf('\n');
disp(p4);
fprintf('Prepivot Regression-Based Bootstrap');
fprintf('\n');
disp(p5);
fprintf('Prepivot Hall-Horowitz Bootstrap');
fprintf('\n');
disp(p6);
fprintf('Computation Error Freq');
fprintf('\n');
disp(p7);
diary off;
