% 	Table1.m
%	Replication file from Bruce E. Hansen 
%	Criterion-Based Inference Without the Information Equality: The Weighted Chi-Square Distribution
%	Creates Table 1
%	Calls function Farebrother

%	Table 1

mus = [1,3,6,12];
nm = length(mus);
size = zeros(2,nm);
c = chi2inv(.95,2);
for i = 1:nm
  mu = mus(i);
  lambda = [1;mu];
  p = 1 - Farebrother(c,lambda);
  size(1,i) = mu;
  size(2,i) = p;
end
diary('Table1.log');
fprintf('Asymptotic Type I Error');
fprintf('\n');
disp(size);
fprintf('\n');
diary off;

