function F = Qcdf(x,lambda,eps) 

% 	Weighted chi-square CDF approximation 
%	Written by Bruce E. Hansen

% 	Arguments:
%	x		scalar, point at which distribution is to be evaluated
% 	lambda		vector, the weights of the weighted chi-square distribution
%			i.e., a set of non-zero eigenvalues	
%	tolerance	scalar, desired level of accuracy for Farebrother approximation
%			default (0.001) set below
% 	Output:
%	G		scalar, cdf evalualted at x
%			Computes P[Q<=x] where Q is weighted sum of chi-square random variables with 1 degree of freedom
%	The calculation is done by one of two methods
%	First, the Farebrother (1984) algorithm is attempted.
%	If this fails to converge, then second, the Lindsay, Pilla, Basak (2000) algorithm with p=4 is attempted
%	If the LPB algorithm fails to converge, then third, the Farebrother algorithm is attempted 
%	with an increased number of maximal series terms and decreased target accuracy

% accuracy
if nargin < 3
	tolerance = .001;	
end
if length(lambda)==2
	maxit = 100000;
else
	maxit = 5000;
end

F = Farebrother(x,lambda,tolerance,maxit);

if ismissing(F)
	F = LPB4(x,lambda);
end

if ismissing(F)
	if length(lambda)==2
		maxit = 200000;
	else
		maxit = 100000;
	end
	tolerance = .01;	
	F = Farebrother(x,lambda,tolerance,maxit);
end

end
