function F = LPB4(x,lambda) 

% 	Weighted chi-square CDF approximation by LPB algorithm with p=4
%	Written by Bruce E. Hansen based on R package momentchi2 by Dean Bodenham

% 	Arguments:
%	x		scalar, point at which distribution is to be evaluated
% 	lambda		vector, the weights of the weighted chi-square distribution
%			i.e., a set of non-zero eigenvalues	
%			dim(lambda)>=4 is recommended
%
% 	Output:
%	G		scalar, cdf evalualted at x
%			Computes P[Q<=x] where Q is weighted sum of chi-square random variables with 1 degree of freedom
%	The expression is a weighted sum of p=4 chi-square distribution functions
%	Due to Lindsay, Pilla, Basak (2000), which allows arbitrary p
%	The result is an approximation, not the exact CDF
%
%	Bodenham's R code claims that if dim(lambda)<4, in some cases the root-finding step for lambdatilde
%	will fail, thus he recommends applying algorithm only for dim(lambda)>=4
%

	p = 4;
	p2 = 2*p;
	p1 = p+1;
	p21 = p2-1;
	s = size(lambda);
	if s(2)>s(1) lambda = lambda'; 	end
	index = (1:p2);
	vsum = sum(lambda.^index);
 	cumulant_vec = (2.^(index-1)) .* factorial(index-1) .* vsum;
 	moment_vec = cumulant_vec;
	for i = 1:p21
		index = (1:i);
		nk = [1,cumprod(flip(index)./index)];
		nkc = nk(index).*cumulant_vec(index).*moment_vec(i+1-index);
		moment_vec(i+1) = moment_vec(i+1) + sum(nkc);
	end
 	lambdatilde = moment_vec(2)/(moment_vec(1)^2) - 1;
 	mvec1 = [1, moment_vec];
	options = optimset('Display','off','Tolx',1e-8);
	d = [0, 0:p21];
	Mi = (1:3)+(0:2)';
	[lambdatilde f flag output] = fzero(@delta_det,[0 lambdatilde],options);
	if flag~=1
		F = missing;
		return
	end
	Mi = (1:4)+(0:3)';
	[lambdatilde f flag output] = fzero(@delta_det,[0 lambdatilde],options);
	if flag~=1
		F = missing;
		return
	end
	Mi = (1:5)+(0:4)';
	[lambdatilde f flag output] = fzero(@delta_det,[0 lambdatilde],options);
	if flag~=1
		F = missing;
		return
	end
 	coeff_vec = [0, 0:p21]*lambdatilde + 1;
 	mvc = mvec1./cumprod(coeff_vec);
	M_p = mvc(Mi);
 	mu_poly_coeff_vec = zeros(p+1,1);
	Meye = eye(p+1);
	M = M_p;
	M(:,p1) = Meye(:,1);
	mu_poly_coeff_vec(1) = det(M);
	M(:,p1) = Meye(:,2);
	mu_poly_coeff_vec(2) = det(M);
	M(:,p1) = Meye(:,3);
	mu_poly_coeff_vec(3) = det(M);
	M(:,p1) = Meye(:,4);
	mu_poly_coeff_vec(4) = det(M);
	M(:,p1) = Meye(:,5);
	mu_poly_coeff_vec(5) = det(M);
 	mu_roots = sort(real(roots(flip(mu_poly_coeff_vec))));
 	VDM = (mu_roots.^(0:(p-1)))';
 	b_vec = M_p(1:p,1);
 	pi_vec = VDM\b_vec;
 	beta = mu_roots.*lambdatilde/2;
 	k = 2./lambdatilde;
 	Fb = chi2cdf(x./beta,k);
 	F = Fb'*pi_vec;

	function D = delta_det(x)
 		mvc = mvec1./cumprod(d*x + 1);
		D = det(mvc(Mi));
	end
end



